/*
 * Decompiled with CFR 0.152.
 */
package com.aote.logic;

import com.aote.entity.EntityServer;
import com.aote.logic.LogicMapper;
import com.aote.logic.PluginMapper;
import com.aote.sql.SqlServer;
import com.aote.util.ExpressionHelper;
import com.aote.util.ResourceHelper;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LogicServer {
    static Logger log = Logger.getLogger(LogicServer.class);
    @Autowired
    private EntityServer entityServer;
    @Autowired
    private SqlServer sqlServer;

    public Object run(String name, String str) throws Exception {
        JSONObject param = null;
        if ((str = str.trim()).startsWith("<") && str.endsWith(">")) {
            param = new JSONObject();
            param.put("xml", (Object)str);
        } else {
            Object json = new JSONTokener(str).nextValue();
            if (json instanceof JSONObject) {
                param = new JSONObject(str);
                if (!param.isNull("data")) {
                    param = param.getJSONObject("data");
                }
            } else if (json instanceof JSONArray) {
                param = new JSONObject();
                param.put("arr", (Object)new JSONArray(str));
            }
        }
        return this.run(name, param);
    }

    public Object run(String name, JSONObject param) throws Exception {
        String path = LogicMapper.getLogic(name);
        String source = ResourceHelper.getString("/logics/" + path);
        source = source.replace("\r\n", "\n");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("data", param);
        params.put("log", log);
        params.put("entity", this.entityServer);
        params.put("sql", this.sqlServer);
        params.put("logic", this);
        Map<String, Object> plugins = PluginMapper.getPlugins();
        for (String key : plugins.keySet()) {
            params.put(key, plugins.get(key));
        }
        Object result = ExpressionHelper.run(source, params);
        return result;
    }
}

