package com.aote.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class ResourceHelper {

	/**
	 * 获取资源文件里，指定全路径文件的文本内容
	 * 
	 * @param fileName
	 *            : 以'/'开始的资源文件的全路径文件名
	 * @return 文件的文本内容
	 */
	public static String getString(String fileName) {
		String result;
		InputStream inputStream = null;
		BufferedReader br = null;
		try {
			inputStream = ResourceHelper.class.getResourceAsStream("/"+fileName);
			if(null == inputStream){
				throw new RuntimeException(fileName + ".文件不存在");
			}
			br = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));

			String line;
			StringBuilder sb = new StringBuilder(); 
			while ((line=br.readLine())!=null) {
				sb.append(line).append("\r\n");
			}
			result = sb.toString();
		}catch(NullPointerException e){
			throw new NullPointerException(fileName + ".文件无配置");
		}catch (RuntimeException e) {
			throw e;
		}catch (Exception e) {
			throw new RuntimeException(e);
		}finally {
			try {
				if(null != inputStream){
					inputStream.close();
				}
				if(br != null) {
					br.close();
				}
			} catch (IOException e) {
				e.printStackTrace();
			} 
		}
		return result;
	}
}
