package com.aote.rs;

import com.aote.logic.LogicServer;
import com.aote.rs.mapper.WebException;
import com.aote.util.ExceptionHelper;
import com.aote.util.JsonTransfer;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import java.util.Map;

@Path("logic")
@Singleton
@Component
public class LogicService {
	static Logger log = Logger.getLogger(LogicService.class);

	@Autowired
	private LogicServer logicServer;

	public static void main(String[] args) {

	}

	/**
	 * 执行业务逻辑(GET方式)
	 *
	 * @param logicName 业务逻辑名称
	 * @param request   HttpServletRequest对象
	 * @return 执行结果
	 */
	@GET
	@Transactional
	@Path("{logic}")
	public String xtSave(@PathParam("logic") String logicName, @Context HttpServletRequest request) throws Exception {
		Map paramMap = request.getParameterMap();
		JSONObject params = new JSONObject(paramMap);
		return xtSave(logicName, params.toString());
	}

	/**
	 * 执行业务逻辑(POST方式)
	 *
	 * @param logicName 业务逻辑名称
	 * @param values JSON资源字符串
	 * @return 执行结果
	 */
	@POST
	@Transactional
	@Path("{logic}")
	public String xtSave(@PathParam("logic") String logicName, String values)
			throws Exception {
		log.debug("logic:" + logicName + ", values:" + values);
		try {
			Object result = logicServer.run(logicName, values);
			if (result == null) {
                return "";
			}
			// 如果执行结果为Map，转换成JSON串
			if (result instanceof Map<?, ?>) {
				Map<String, Object> map = (Map<String, Object>)result;
				JSONObject json = (JSONObject) new JsonTransfer().MapToJson(map);
				if (!json.isNull(" xml")) {
					return (String) json.get("xml");
				}
				return json.toString();
			}
			if (result instanceof JSONObject) {
				JSONObject json = (JSONObject) result;
				if (!json.isNull("xml")) {
					return json.getString("xml");
				}
				return json.toString();
			}
			return result.toString();
		} catch (Exception ex) {
			log.error(ExceptionHelper.stackToString(ex));
			WebException wex = this.getWebException(ex);
			if (wex != null) 
			{
				throw wex;
			}
			throw ex;
		}
	}
	
	@POST
	@Path("noTransc/{logic}")
	public String save(@PathParam("logic") String logicName, String values)
			throws Exception {
		log.debug("logic:" + logicName + ", values:" + values);
		try {
			Object result = logicServer.noTranscRun(logicName, values);
			if (result == null) {
                return "";
			}
			// 如果执行结果为Map，转换成JSON串
			if (result instanceof Map<?, ?>) {
				Map<String, Object> map = (Map<String, Object>)result;
				JSONObject json = (JSONObject) new JsonTransfer().MapToJson(map);
				if (!json.isNull("xml")) {
					return (String) json.get("xml");
				}
				return json.toString();
			}
			if (result instanceof JSONObject) {
				JSONObject json = (JSONObject) result;
				if (!json.isNull("xml")) {
					return json.getString("xml");
				}
				return json.toString();
			}
			return result.toString();
		} catch (Exception ex) {
			log.error(ExceptionHelper.stackToString(ex));
			WebException wex = this.getWebException(ex);
			if (wex != null) 
			{
				throw wex;
			}
			throw ex;
		}
	}
	
	// 找到WebException异常
	// return - 不存在，返回null
	private WebException getWebException(Exception ex)
	{
		Throwable cause = ex;
		while (cause != null)
		{
			if (cause instanceof WebException)
			{
				return (WebException)cause;
			}
			cause = cause.getCause();
		}
		
		return null;
	}

	//服务器启动时加载模块至readis
	@PostConstruct
	public void redisCacheLogic() throws Exception {
		logicServer.redisCacheLogic();
	}
}
