package com.aote.rs;

import com.aote.entity.EntityServer;
import com.aote.module.ModuleMapper;
import com.aote.sql.SqlServer;
import com.aote.util.ResourceHelper;

import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.*;
import javax.ws.rs.core.Context;

import java.io.*;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.*;

@Path("file")
@Component
@Transactional
public class FileService {

	static Logger log = Logger.getLogger(FileService.class);

	@Autowired
	private SessionFactory sessionFactory;
	
	@Autowired
	private EntityServer entityServer;

	@Autowired
	private SqlServer sqlServer;

	private static byte[] subBytes(byte[] b, int from, int end) {
		byte[] result = new byte[end - from];
		System.arraycopy(b, from, result, 0, end - from);
		return result;
	}
	private static int locateEnd(byte[] bytes, int start, int end, String endStr) {
		byte[] endByte = endStr.getBytes();
		for (int i = start + 1; i < end; i++) {
			if (bytes[i] == endByte[0]) {
				int k = 1;
				while (k < endByte.length) {
					if (bytes[i + k] != endByte[k]) {
						break;
					}
					k++;
				}
				
				if (i == 3440488) {
					System.out.println("start");
				}
				// 返回结束符的开始位置
				if (k == endByte.length) {
					return i;
				}
			}
		}
		return 0;
	}

	@POST
	@Path("upload")
	public String fileUpload(@Context HttpServletRequest request,
			@Context HttpServletResponse response) throws Exception {
		String realpath = getPath("uploadFilepath");
		JSONObject result = new JSONObject();
		File file = new File(realpath+File.separator+getNowDate());
		if (!file.exists()) {
			file.mkdirs();
		}
		String downloadpath;
		String username = URLDecoder.decode(request.getHeader("username"), "UTF-8");
		String blodid = request.getHeader("blodid");
		downloadpath = getPath("downloadpath");
		
		System.out.println(downloadpath);
		System.out.println(username);
		System.out.println(blodid);
		System.out.println(realpath);
		// 1.判断当前request消息实体的总长度
		int totalBytes = request.getContentLength();
		System.out.println("当前数据总长度:" + totalBytes);
		// 2.在消息头类型中找出分解符,例如:boundary=----WebKitFormBoundaryeEYAk4vG4tRKAlB6
		String contentType = request.getContentType();
		System.out.println(contentType);
		int position = contentType.indexOf("boundary=");

		String startBoundary = "--"
				+ contentType.substring(position + "boundary=".length());
		String endBoundary = startBoundary + "--";
		// 将request的输入流读入到bytes中
		InputStream inputStream = request.getInputStream();
		DataInputStream dataInputStream = new DataInputStream(inputStream);
		byte[] bytes = new byte[totalBytes];
		dataInputStream.readFully(bytes);
		dataInputStream.close();
		BufferedReader reader = new BufferedReader(new StringReader(new String(
				bytes)));
		int temPosition = 0;
		boolean flag = false;
		int end = 0;
		while (true) {
			// 当读取一次文件信息后
			if (flag) {
				bytes = subBytes(bytes, end, totalBytes);
				temPosition = 0;
				reader = new BufferedReader(new StringReader(new String(bytes)));
			}
			// 读取一行的信息:------WebKitFormBoundary5R7esAd459uwQsd5,即:lastBoundary
			String str = reader.readLine();
			System.out.println("this line is:" + str);
			// 换行算两个字符
			temPosition += str.getBytes().length + 2;
			// endBoundary:结束
			if (str.equals(endBoundary)) {
				break;
			}
			// 表示头信息的开始(一个标签,input,select等)
			if (str.startsWith(startBoundary)) {
				// 判断当前头对应的表单域类型

				str = reader.readLine(); // 读取当前头信息的下一行:Content-Disposition行
				temPosition += str.getBytes().length + 2;

				int position1 = str.indexOf("filename="); // 判断是否是文件上传
				// such as:Content-Disposition: form-data; name="fileName";
				// filename="P50611-162907.jpg"
				if (position1 == -1) {// 表示是普通文本域上传

				} else {// position1!=-1,表示是文件上传
						// 解析当前上传的文件对应的name(input标签的name),以及fieldname:文件名
					int position2 = str.indexOf("name=");
					// 去掉name与filename之间的"和;以及空格
					String name = str.substring(position2 + "name=".length()
							+ 1, position1 - 3);
					// 去掉两个"
					
					String filename = str.substring(
							position1 + "filename=".length() + +1,
							str.length() - 1);
					filename = new String(filename.getBytes(), StandardCharsets.UTF_8);
					
					String uploaddate = getDate();
					
					filename = filename.split("\\.")[0] + "_" + username + "_" +uploaddate + "." + filename.split("\\.")[1];
					
					System.out.println(filename);
					// 读取行,such as:Content-Type: image/jpeg,记录字节数,此处两次换行
					temPosition += (reader.readLine().getBytes().length + 4);
					end = locateEnd(bytes, temPosition, totalBytes,
							endBoundary);
					DataOutputStream dOutputStream = new DataOutputStream(
							new FileOutputStream(new File(
									file.getAbsolutePath() + File.separator
											+ filename)));
					dOutputStream.write(bytes, temPosition, end - temPosition
							- 2);
					dOutputStream.close();
					flag = true; 
					downloadpath = file.getAbsolutePath() + File.separator + filename;
					// String filetype=filename.split("\\.")[1];
					String filetype=filename.substring(filename.lastIndexOf('.')+1);
					Map<String, Object> map = new HashMap<>();
					map.put("f_filename", filename);
					map.put("f_username", username);
					map.put("f_uploaddate", uploaddate);
					map.put("f_blobid", blodid); 
					map.put("f_filetype",filetype);
					map.put("f_downloadpath", downloadpath);
					map.put("f_realpath", realpath);
					String jsonFileID=entityServer.save("t_files", map);
					JSONObject JObj = new JSONObject(jsonFileID);
					int id =  (int) JObj.get("id");
					map.put("id",id);
					result=new JSONObject(map);
				}
			}
		}
		result.put("path", downloadpath);
		result.put("result", "success");
		System.out.println("1111111111" + result.toString());
		return result.toString();
	}

	@POST
	@Path("uploadFile")
	public String baseFileUpload(@Context HttpServletRequest request,@Context HttpServletResponse response) throws Exception {
		String realpath = getPath("uploadFilepath");
		JSONObject result = new JSONObject();
		File file = new File(realpath+File.separator+getNowDate());
		if (!file.exists()) {
			file.mkdirs();
		}
		String downloadpath;
		//获取所有请求头参数
		Enumeration headerNames = request.getHeaderNames();
		Map<String, Object> map = new HashMap<>();
		while (headerNames.hasMoreElements()) {
			String key = (String) headerNames.nextElement();
			String value = URLDecoder.decode(request.getHeader(key),"UTF-8");
			map.put(key, value);
		}
		downloadpath = getPath("downloadpath");
		// 1.判断当前request消息实体的总长度
		int totalBytes = request.getContentLength();
		System.out.println("当前数据总长度:" + totalBytes);
		// 2.在消息头类型中找出分解符,例如:boundary=----WebKitFormBoundaryeEYAk4vG4tRKAlB6
		String contentType = request.getContentType();
		System.out.println(contentType);
		int position = contentType.indexOf("boundary=");
		String startBoundary = "--"
				+ contentType.substring(position + "boundary=".length());
		String endBoundary = startBoundary + "--";
		// 将request的输入流读入到bytes中
		InputStream inputStream = request.getInputStream();
		DataInputStream dataInputStream = new DataInputStream(inputStream);
		byte[] bytes = new byte[totalBytes];
		dataInputStream.readFully(bytes);
		dataInputStream.close();
		BufferedReader reader = new BufferedReader(new StringReader(new String(
				bytes)));
		int temPosition = 0;
		boolean flag = false;
		int end = 0;
		while (true) {
			// 当读取一次文件信息后
			if (flag) {
				bytes = subBytes(bytes, end, totalBytes);
				temPosition = 0;
				reader = new BufferedReader(new StringReader(new String(bytes)));
			}
			// 读取一行的信息:------WebKitFormBoundary5R7esAd459uwQsd5,即:lastBoundary
			String str = reader.readLine();
			System.out.println("this line is:" + str);
			// 换行算两个字符
			temPosition += str.getBytes().length + 2;
			// endBoundary:结束
			if (str.equals(endBoundary)) {
				break;
			}
			// 表示头信息的开始(一个标签,input,select等)
			if (str.startsWith(startBoundary)) {
				// 判断当前头对应的表单域类型

				str = reader.readLine(); // 读取当前头信息的下一行:Content-Disposition行
				temPosition += str.getBytes().length + 2;

				int position1 = str.indexOf("filename="); // 判断是否是文件上传
				// such as:Content-Disposition: form-data; name="fileName";
				// filename="P50611-162907.jpg"
				if (position1 == -1) {// 表示是普通文本域上传

				} else {// position1!=-1,表示是文件上传
					// 解析当前上传的文件对应的name(input标签的name),以及fieldname:文件名
					int position2 = str.indexOf("name=");
					// 去掉name与filename之间的"和;以及空格
					String name = str.substring(position2 + "name=".length()
							+ 1, position1 - 3);
					// 去掉两个"

					String filename = str.substring(
							position1 + "filename=".length() + +1,
							str.length() - 1);
					filename = new String(filename.getBytes(), StandardCharsets.UTF_8);

					String uploaddate = getDate();

					filename = filename.split("\\.")[0] + "_" + map.get("username") + "_" +uploaddate + "." + filename.split("\\.")[1];

					System.out.println(filename);
					// 读取行,such as:Content-Type: image/jpeg,记录字节数,此处两次换行
					temPosition += (reader.readLine().getBytes().length + 4);
					end = locateEnd(bytes, temPosition, totalBytes,
							endBoundary);
					DataOutputStream dOutputStream = new DataOutputStream(
							new FileOutputStream(new File(
									file.getAbsolutePath() + File.separator
											+ filename)));
					dOutputStream.write(bytes, temPosition, end - temPosition
							- 2);
					dOutputStream.close();
					flag = true;
					downloadpath = file.getAbsolutePath() + File.separator + filename;
					// String filetype=filename.split("\\.")[1];
					String filetype=filename.substring(filename.lastIndexOf('.')+1);
					map.put("f_filename", filename);
					map.put("f_uploaddate", uploaddate);
					map.put("f_filetype",filetype);
					map.put("f_downloadpath", downloadpath);
					map.put("f_realpath", realpath);
					String jsonFileID=entityServer.save("t_files", map);
					JSONObject JObj = new JSONObject(jsonFileID);
					int id =  (int) JObj.get("id");
					map.put("id",id);
					result=new JSONObject(map);
				}
			}
		}
		result.put("path", downloadpath);
		result.put("result", "success");
		return result.toString();
	}

	// 保存文件
	@SuppressWarnings("finally")
	@Path("savefile")
	@POST
	public String savefile(byte[] file,
			@QueryParam("filename") String filename,
			@QueryParam("module") String module) {
		try {
			String realpath = ModuleMapper.getAttr(module, "upload");
			realpath = this.getRealPath(realpath) + File.separator + filename;
			DataOutputStream dOutputStream = 
					new DataOutputStream(new FileOutputStream(new File(realpath)));
			dOutputStream.write(file);
			dOutputStream.close();
			// 把文件路径存入文件映射表
			String filetype=filename.split("\\.")[1];
			JSONObject map = new JSONObject();
			map.put("f_filename", filename);
			String uploaddate = getDate();
			map.put("f_uploaddate", uploaddate);
			map.put("f_filetype",filetype);
			map.put("f_realpath", realpath); 
			JSONObject result = new JSONObject(entityServer.partialSave("t_files", map));
			return result.getString("id");
		} catch(Exception e) {
			throw new RuntimeException(e);
		}
	}

	// 获得图片
	@Path("getfile/{blobid}")
	@GET
	public byte[] getfile(@PathParam("blobid") String blobid) {
		try {
			// 获取文件真实路径
			JSONArray array = this.sqlServer.query(
					"select f_realpath from t_files where id=" + blobid
			);
			if (array.length() == 0)
				return null;
			JSONObject map = array.getJSONObject(0);
			// 获得文件名
			String filename = map.getString("f_realpath");
			// 获得文件
			File file = new File(filename);
			FileInputStream in = new FileInputStream(file);
			byte[] result = new byte[(int)file.length()];
			in.read(result);
			//response.setStatus(HttpServletResponse.SC_OK);
			//response.setContentType("application/octet-stream");
			//response.setHeader("Content-Disposition", "attachment;filename=\"" + filename + "\"");
			// 把文件的内容送入响应流中
			//OutputStream os = new BufferedOutputStream(response.getOutputStream());
			//transformStream(in, os);
			//in.close();
			//os.close();
			return result;
		} catch (RuntimeException e) {
			throw e;
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}
			
	public void transformStream(InputStream is, OutputStream os) {
		try {
			byte[] buffer = new byte[1024];
			// 读取的实际长度
			int length = is.read(buffer);
			while (length != -1) {
				os.write(buffer, 0, length);
				length = is.read(buffer);
			}
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	// 按系统日期，建立不同文件夹，获取建立的文件夹位置
	private String getRealPath(String realpath) {
		// 进入模块文件夹
		Date d = new Date();
		realpath = realpath + File.separator + (d.getYear() + 1900) + File.separator + (d.getMonth() + 1) + File.separator + d.getDate();
		File f = new File(realpath);
		try {
			if (!f.exists()) {
				f.mkdirs();
			}
			return realpath;
		} catch (RuntimeException e) {
			throw e;
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
 	}
	
	private String getNowDate()
	{
		SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd");
		return sdf.format(new Date());
	}
	
	public String getDate() {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
		return sdf.format(new Date());
	}
	/**
	 * 获取配置文件上传的真实存储路径
	 */
	public String getPath(String pathname) throws IOException {
		String proPath = System.getProperty("user.dir");
		System.out.println(proPath);
		Properties pro = new Properties();
		FileInputStream in = new FileInputStream(proPath+"\\file.properties");
		pro.load(in);
		String path = pro.getProperty(pathname);
		System.out.println(path);
		in.close();
		return path;
	}
	/**
	 * 删除文件
	 */
	@POST
	@Path("deleteFile")
	public String deleteFile(@Context HttpServletRequest request, @Context HttpServletResponse response) throws JSONException, IOException {
		request.setCharacterEncoding("utf-8");
		JSONObject obj = new JSONObject(new JSONTokener(request.getInputStream()));
		System.out.println(obj.toString());

		String path = new String(obj.getString("path").getBytes(), StandardCharsets.UTF_8);
		String blobid = obj.getString("blobid");
		System.out.println(path);
		path.split("/");
		System.out.println(blobid);
		File file = new File(path);
		if(file.exists()) {
			file.delete();
			Session session = sessionFactory.openSession();
			Query query = session.createQuery("delete from t_files where blobid='" + blobid + "' and "
					+ "filename='" + path.split("/")[path.split("/").length - 1] + "'");
			query.executeUpdate();
			session.close();
			System.out.println("success");
			return "success";
		}
		System.out.println("file is not exists");
		return "file is not exists";
		
	}

	/**
	 * 从资源文件的vue目录里获取vue组件文件内容
	 * @param fileName 文件名称，支持汉字
	 * @return 文件内容
	 */
	@GET
	@Path("vue/{filename}")
	public String getVueFile(@PathParam("filename") String fileName) {
		log.debug(fileName);
		return ResourceHelper.getString("/vue/" + fileName);
	}
}
