package com.aote.logic;

import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * logic映射器
 * 
 * @author HNS
 *
 */
public class LogicMapper {

	static Logger log = Logger.getLogger(LogicMapper.class);

	private static Map<String, Map<String, String>> map;

	public static synchronized String getLogic(String alias) {
		if (map == null)
			loadMap();
		if (map.containsKey(alias))
			return map.get(alias).get("path");
		else
			return null;
	}
	
	public static synchronized Map<String, Map<String, String>> getMap() {
		if (map == null)
			loadMap();
		return LogicMapper.map;
	}

	public static synchronized String getAttr(String alias, String name) {
		if (map == null)
			loadMap();
		if (map.containsKey(alias))
			return map.get(alias).get(name);
		else
			return null;
	}

	@SuppressWarnings("rawtypes")
	private static void loadMap() {
		map = new HashMap<>();

		SAXReader reader = new SAXReader();
		InputStream module = LogicMapper.class.getClassLoader()
				.getResourceAsStream("module.xml");
		try {
			if (module != null) {
				parseModule(module);
			}
			InputStream input = LogicMapper.class.getClassLoader()
					.getResourceAsStream("logic.xml");
			if (input != null) {
				Document document = reader.read(input);
				Element root = document.getRootElement();
				for (Iterator it = root.elementIterator("logic"); it.hasNext();) {
					Element elm = (Element) it.next();
					// 设置业务逻辑属性
					Map<String, String> logic = new HashMap<>();
					String alias = elm.attribute("alias").getValue();
					logic.put("alias", alias);
					String path = elm.attribute("path").getValue();
					logic.put("path", "logics/" + path);
					String log = elm.attributeValue("log");
					logic.put("log", log);
					String mobile = elm.attributeValue("mobile");
					logic.put("mobile", mobile);
					map.put(alias, logic);
				}
			}
		} catch (Exception ex) {
			throw new RuntimeException(ex);
		}

	}

	private static void parseModule(InputStream input) throws Exception {
		SAXReader reader = new SAXReader();
		Document document = reader.read(input);
		Element root = document.getRootElement();
		for (Iterator it = root.elementIterator("module"); it.hasNext();) {
			Element elm = (Element) it.next();
			String name = elm.attribute("name").getValue();
			putMap(name, reader, null);
			for (Iterator children = elm.elementIterator("module"); children
					.hasNext();) {
				Element childElm = (Element) children.next();
				String childname = childElm.attribute("name").getValue();
				putMap(childname, reader, name);
			}
		}
	}

	private static void putMap(String name, SAXReader reader, String parent)
			throws Exception {

		String str = (parent == null ? name + "/logic.xml" : parent + "/"
				+ name + "/logic.xml");
		InputStream moduleLogic = LogicMapper.class.getClassLoader()
				.getResourceAsStream(str);

		if (moduleLogic == null) {
			throw new RuntimeException("注意！！！找不到文件：" + str);
		}
		Document docLogic = reader.read(moduleLogic);
		Element rootLogic = docLogic.getRootElement();
		for (Iterator item = rootLogic.elementIterator("logic"); item.hasNext();) {
			Element elmment = (Element) item.next();
			String aliasLogic = elmment.attribute("alias").getValue();
			String pathLogic = elmment.attribute("path").getValue();
			String log = elmment.attributeValue("log");
			String mobile = elmment.attributeValue("mobile");
			
			// 验证别名是否重复
			if (map.containsKey(aliasLogic)) {
				throw new Exception("别名" + aliasLogic + "已存在");
			}

			String path = (parent == null ? name + "/logics/" : parent
					+ "/" + name + "/logics/")
					+ pathLogic;
			// 设置业务逻辑属性
			Map<String, String> logic = new HashMap<>();
			logic.put("alias", aliasLogic);
			logic.put("path", path);
			logic.put("log", log);
			logic.put("mobile", mobile);
			map.put(aliasLogic, logic);
		}
	}

	// public static void main(String[] args) {
	// LogicMapper.loadMap();
	// for(String key : map.keySet())
	// System.out.println("alias:"+key+"  path:"+map.get(key));
	// }
}
