package com.aote.filter;

import com.af.plugins.RestTools;
import com.af.plugins.RestTools2;
import com.aote.ThreadResource;
import org.apache.log4j.Logger;
import org.json.JSONObject;

import javax.servlet.*;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

public class LoginFilter implements Filter {
    static Logger log = Logger.getLogger(LoginFilter.class);

    /**
     * 从cookie里获取给定主键的内容
     * @param key
     * @return
     */
    private String getCookie(HttpServletRequest request, String key) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for(Cookie cookie : request.getCookies()) {
            if (cookie.getName().equals(key)) {
                return cookie.getValue();
            }
        }
        return null;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        // 从cookie中获取登录用户id
        String loginId = getCookie((HttpServletRequest) request, "loginId");
        log.debug("loginId=" + loginId);
        if (loginId == null) {
            chain.doFilter(request, response);
            return;
        }
        try {
            // 根据用户id从ldap中获取业务逻辑等内容存放路径
            RestTools rest = new RestTools();
            String str = rest.post("/rs/search", "{source:'this.getInfo()',userid:'" + loginId + "'}");
            log.debug("用户信息：" + str);
            JSONObject json = new JSONObject(str);
            // 把用户完整信息存放到线程变量里
            ThreadResource.LoginUser.set(json);

            String res = json.getString("dir");
            log.debug("组件目录：" + res);
            if (res != null && !res.equals("null")) {
                // 把存放路径放到线程变量中，供其他地方调用
                ThreadResource.ComponentDir.set(res);
            }
        } catch (Exception e) {
            // 过滤器处理异常，打印异常
            e.printStackTrace();
        }

        chain.doFilter(request, response);
   }

    @Override
    public void destroy() {
    }
}
