/*
 * Decompiled with CFR 0.152.
 */
package com.aote.util;

import com.aote.sql.AliasTransformer;
import com.aote.util.JsonTransfer;
import java.util.List;
import java.util.Map;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.transform.ResultTransformer;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.orm.hibernate3.HibernateCallback;

public class SqlHelper {
    public static JSONArray query(Session session, String sql) throws Exception {
        JSONArray array = new JSONArray();
        HibernateSQLCall sqlCall = new HibernateSQLCall(sql, 0, 9999999);
        sqlCall.transformer = AliasTransformer.INSTANCE;
        List list = (List)sqlCall.doInHibernate(session);
        for (Map map : list) {
            JSONObject json = (JSONObject)new JsonTransfer().MapToJson(map);
            array.put((Object)json);
        }
        return array;
    }

    public static JSONArray query(Session session, String sql, int pageNo, int pageSize) throws Exception {
        JSONArray array = new JSONArray();
        HibernateSQLCall sqlCall = new HibernateSQLCall(sql, pageNo, pageSize);
        sqlCall.transformer = AliasTransformer.INSTANCE;
        List list = (List)sqlCall.doInHibernate(session);
        for (Map map : list) {
            JSONObject json = (JSONObject)new JsonTransfer().MapToJson(map);
            array.put((Object)json);
        }
        return array;
    }

    public static JSONArray hqlQuery(Session session, String sql) throws Exception {
        JSONArray array = new JSONArray();
        HibernateHQLCall sqlCall = new HibernateHQLCall(sql, 0, 9999999);
        List list = (List)sqlCall.doInHibernate(session);
        for (Map map : list) {
            JSONObject json = (JSONObject)new JsonTransfer().MapToJson(map);
            array.put((Object)json);
        }
        return array;
    }

    public static JSONArray hqlQuery(Session session, String sql, int pageNo, int pageSize) throws Exception {
        JSONArray array = new JSONArray();
        HibernateHQLCall sqlCall = new HibernateHQLCall(sql, pageNo, pageSize);
        List list = (List)sqlCall.doInHibernate(session);
        for (Map map : list) {
            JSONObject json = (JSONObject)new JsonTransfer().MapToJson(map);
            array.put((Object)json);
        }
        return array;
    }

    public static int bulkUpdate(Session session, String sql) {
        Query queryObject = session.createQuery(sql);
        return new Integer(queryObject.executeUpdate());
    }

    public static int bulkSQLUpdate(Session session, String sql) {
        SQLQuery queryObject = session.createSQLQuery(sql);
        return new Integer(queryObject.executeUpdate());
    }

    static class HibernateHQLCall
    implements HibernateCallback {
        String sql;
        int page;
        int rows;
        public ResultTransformer transformer = null;

        public HibernateHQLCall(String sql, int page, int rows) {
            this.sql = sql;
            this.page = page;
            this.rows = rows;
        }

        public Object doInHibernate(Session session) {
            Query q = session.createQuery(this.sql);
            if (this.transformer != null) {
                q.setResultTransformer(this.transformer);
            }
            try {
                List result = q.setFirstResult(this.page * this.rows).setMaxResults(this.rows).list();
                return result;
            }
            catch (SQLGrammarException ex) {
                String msg = "sql:\n" + this.sql + "\n" + ex.getMessage();
                throw new SQLGrammarException(msg, ex.getSQLException());
            }
        }
    }

    public static class HibernateSQLCall
    implements HibernateCallback {
        String sql;
        int page;
        int rows;
        public ResultTransformer transformer = null;

        public HibernateSQLCall(String sql, int page, int rows) {
            this.sql = sql;
            this.page = page;
            this.rows = rows;
        }

        public Object doInHibernate(Session session) {
            SQLQuery q = session.createSQLQuery(this.sql);
            if (this.transformer != null) {
                q.setResultTransformer(this.transformer);
            }
            try {
                List result = q.setFirstResult(this.page * this.rows).setMaxResults(this.rows).list();
                return result;
            }
            catch (SQLGrammarException ex) {
                String msg = "sql:\n" + this.sql + "\n" + ex.getMessage();
                throw new SQLGrammarException(msg, ex.getSQLException());
            }
        }
    }
}

