/*
 * Decompiled with CFR 0.152.
 */
package com.aote.timer;

import com.aote.logic.LogicServer;
import com.aote.timer.CommonCallBack;
import com.aote.timer.CommonTarget;
import com.aote.timer.ISource;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class TaskJob {
    @Autowired
    private LogicServer logicServer;
    private List<ISource> sources;
    private CommonTarget commonTarget;
    private CommonCallBack commonCallBack;

    public void run() {
        long startTime = System.currentTimeMillis();
        if (this.sources.size() > 0) {
            for (int i = 0; i < this.sources.size(); ++i) {
                ISource source = this.sources.get(i);
                List list = (List)source.getSource();
                if (list == null || list.size() <= 0) continue;
                List<JSONArray> resultList = null;
                if (list.size() <= 0) continue;
                if (this.commonTarget == null) {
                    this.commonCallBack.runCallBack(list);
                    continue;
                }
                resultList = this.commonTarget.sendTarget(list);
                if (resultList == null) continue;
                this.commonCallBack.runCallBack(resultList);
            }
        }
        long endTime = System.currentTimeMillis();
        System.out.println("run()\u65b9\u6cd5\u672c\u6b21\u8017\u65f6" + (endTime - startTime) + "\u6beb\u79d2");
    }

    public void runLogic() {
        List<String> logics = this.commonCallBack.getLogics();
        for (int i = 0; i < logics.size(); ++i) {
            try {
                this.logicServer.run(logics.get(i), new JSONObject());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public List<ISource> getSources() {
        return this.sources;
    }

    public void setSources(List<ISource> sources) {
        this.sources = sources;
    }

    public void setCommonTarget(CommonTarget commonTarget) {
        this.commonTarget = commonTarget;
    }

    public void setCommonCallBack(CommonCallBack commonCallBack) {
        this.commonCallBack = commonCallBack;
    }
}

