/*
 * Decompiled with CFR 0.152.
 */
package com.aote.sql;

import com.af.util.Pair;
import com.aote.entity.EntityServer;
import com.aote.sql.SqlMapper;
import com.aote.util.ExpressionHelper;
import com.aote.util.JsonHelper;
import com.aote.util.ResourceHelper;
import com.aote.util.SqlHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SqlServer {
    static Logger log = Logger.getLogger(SqlServer.class);
    @Autowired
    public SessionFactory sessionFactory;
    public Session assignedSession;

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setAssignedSession(Session session) {
        this.assignedSession = session;
    }

    public JSONObject queryTotal(String name, String str) throws Exception {
        JSONObject param = null;
        Object sums = null;
        if (str != null && !str.isEmpty()) {
            JSONObject json = new JSONObject(str);
            if (json.has("data")) {
                param = json.getJSONObject("data");
            }
            if (json.has("sums")) {
                sums = json.get("sums");
            }
        }
        Map<String, Object> params = JsonHelper.toMap(param);
        String sql = this.call(name, params);
        sql = this.filterOutOrderBy(sql, sums);
        Session session = this.assignedSession == null ? this.sessionFactory.getCurrentSession() : this.assignedSession;
        JSONArray array = SqlHelper.query(session, sql);
        return array.getJSONObject(0);
    }

    public JSONObject queryHqlTotal(String name, String str) throws Exception {
        JSONObject json;
        JSONObject param = null;
        if (str != null && !str.isEmpty() && (json = new JSONObject(str)).has("data")) {
            param = json.getJSONObject("data");
        }
        Map<String, Object> params = JsonHelper.toMap(param);
        String sql = this.call(name, params);
        Session session = this.assignedSession == null ? this.sessionFactory.getCurrentSession() : this.assignedSession;
        JSONArray array = SqlHelper.hqlQuery(session, sql);
        return array.getJSONObject(0);
    }

    public JSONArray query(String name, String str) throws Exception {
        return this.query(name, 1, 1000, str);
    }

    public JSONArray query(String name, String str, Integer pageSize) throws Exception {
        return pageSize <= 0 ? this.query(name, 1, 9999999, str) : this.query(name, 1, (int)pageSize, str);
    }

    public JSONArray query(String name, JSONObject params) throws Exception {
        Map<String, Object> map = JsonHelper.toMap(params);
        return this.query(name, 1, 1000, map);
    }

    public JSONArray query(String name, JSONObject params, Integer pageSize) throws Exception {
        Map<String, Object> map = JsonHelper.toMap(params);
        return pageSize <= 0 ? this.query(name, 1, 9999999, map) : this.query(name, 1, (int)pageSize, map);
    }

    public JSONArray query(String name, Map<String, Object> params) throws Exception {
        return this.query(name, 1, 1000, params);
    }

    public JSONArray query(String name, Map<String, Object> params, Integer pageSize) throws Exception {
        return pageSize <= 0 ? this.query(name, 1, 9999999, params) : this.query(name, 1, (int)pageSize, params);
    }

    public JSONArray query(String name, int pageNo, int pageSize, String str) throws Exception {
        if (pageNo <= 0) {
            pageNo = 1;
        }
        if (pageSize < 1) {
            pageSize = 1000;
        }
        JSONObject param = null;
        if (str != null && !str.isEmpty()) {
            param = new JSONObject(str);
            param = param.getJSONObject("data");
        }
        Map<String, Object> params = JsonHelper.toMap(param);
        return this.query(name, pageNo, pageSize, params);
    }

    public JSONArray query(String name, int pageNo, int pageSize, Map<String, Object> params) throws Exception {
        String sql = this.call(name, params);
        Session session = this.assignedSession == null ? this.sessionFactory.getCurrentSession() : this.assignedSession;
        JSONArray array = SqlHelper.query(session, sql, pageNo - 1, pageSize);
        log.debug((Object)array.toString());
        return array;
    }

    public JSONArray query(String sql) throws Exception {
        Session session = this.assignedSession == null ? this.sessionFactory.getCurrentSession() : this.assignedSession;
        JSONArray array = SqlHelper.query(session, sql);
        log.debug((Object)array.toString());
        return array;
    }

    public void run(String sql) throws NullPointerException {
        Session session = this.assignedSession == null ? this.sessionFactory.getCurrentSession() : this.assignedSession;
        SqlHelper.bulkSQLUpdate(session, sql);
    }

    public void run(String sql, String flag) throws NullPointerException {
        Session session = this.assignedSession == null ? this.sessionFactory.getCurrentSession() : this.assignedSession;
        String[] sqlStr = sql.trim().split("\\s+");
        if ("delete".equals(sqlStr[0])) {
            this.runDeleteSQL(session, sql);
        } else if ("update".equals(sqlStr[0])) {
            this.runUpdateSQL(session, sql);
        } else {
            SqlHelper.bulkSQLUpdate(session, sql);
        }
    }

    public void runDeleteSQL(Session session, String sql) {
        EntityServer entityServer = new EntityServer();
        String[] sqlStr = sql.trim().split("\\s+");
        List<String> childStr = entityServer.getChildName(sqlStr[2]);
        for (String str : childStr) {
            String sqlRes = sql.replaceFirst(sqlStr[2], str);
            this.doCascade(session, sqlRes);
            SqlHelper.bulkSQLUpdate(session, sqlRes);
        }
        this.doCascade(session, sql);
        SqlHelper.bulkSQLUpdate(session, sql);
    }

    public void runUpdateSQL(Session session, String sql) {
        EntityServer entityServer = new EntityServer();
        String[] sqlStr = sql.trim().split("\\s+");
        List<String> childStr = entityServer.getChildName(sqlStr[1]);
        for (String str : childStr) {
            String sqlRes = sql.replaceFirst(sqlStr[1], str);
            SqlHelper.bulkSQLUpdate(session, sqlRes);
        }
        SqlHelper.bulkSQLUpdate(session, sql);
    }

    public void doCascade(Session session, String sql) {
        sql = sql.trim();
        log.debug((Object)"Start into doCascade");
        EntityServer entityServer = new EntityServer();
        HashMap<String, HashMap<String, Object>> metaMap = EntityServer.metaMap;
        String[] sqlStr = sql.split("\\s+");
        String idnum = (String)metaMap.get(sqlStr[2]).get("idColName");
        String resql = sql.replaceFirst(sqlStr[0], "SELECT " + idnum);
        try {
            JSONArray value = this.query(resql);
            if (value.length() > 0) {
                for (int j = 0; j < value.length(); ++j) {
                    JSONObject job = value.getJSONObject(j);
                    String res = job.get(idnum).toString();
                    this.cascadeDelete(session, sqlStr[2], res);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cascadeDelete(Session session, String tableName, String idValue) {
        EntityServer entityServer = new EntityServer();
        log.debug((Object)"Start into cascadeDelete");
        HashMap<String, HashMap<String, Object>> metaMap = EntityServer.metaMap;
        String idNum = (String)metaMap.get(tableName).get("idColName");
        this.deleteFileDB(tableName, idValue);
        if (metaMap.containsKey(tableName)) {
            ArrayList cascadeTable = new ArrayList();
            HashMap cascadMap = (HashMap)metaMap.get(tableName).get("onetoone");
            cascadMap.putAll((HashMap)metaMap.get(tableName).get("onetomany"));
            if (cascadMap != null) {
                Set keys = cascadMap.keySet();
                Iterator iter = keys.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    cascadeTable.add(iter.next());
                    ++i;
                }
                for (String str : cascadeTable) {
                    Pair pair = (Pair)cascadMap.get(str);
                    String tableString = (String)metaMap.get(pair.col).get("tableName");
                    String tableId = (String)metaMap.get(pair.col).get("idColName");
                    String selSql = new String();
                    selSql = metaMap.get(pair.col).get("idType") == "STRING" ? "SELECT " + tableId + " FROM " + tableString + " WHERE " + pair.type + "='" + idValue + "'" : "SELECT " + tableId + " FROM " + tableString + " WHERE " + pair.type + "=" + idValue;
                    try {
                        JSONArray array = this.query(selSql);
                        if (array.length() <= 0) continue;
                        for (int j = 0; j < array.length(); ++j) {
                            JSONObject job = array.getJSONObject(j);
                            String res = job.get(tableId).toString();
                            String sqlStr = new String();
                            sqlStr = job.get(tableId) instanceof String ? "DELETE FROM " + pair.col + " WHERE " + tableId + "='" + res + "'" : "DELETE FROM " + pair.col + " WHERE " + tableId + "=" + res;
                            this.runDeleteSQL(session, sqlStr);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        String delSql = new String();
        delSql = metaMap.get(tableName).get("idType") == "STRING" ? "DELETE FROM " + tableName + " WHERE " + idNum + "= '" + idValue + "'" : "DELETE FROM " + tableName + " WHERE " + idNum + "=" + idValue;
        SqlHelper.bulkSQLUpdate(session, delSql);
    }

    public void deleteFileDB(String tableName, String idValue) {
        EntityServer entityServer = new EntityServer();
        log.debug((Object)"Start into deleteFile");
        HashMap<String, HashMap<String, Object>> metaMap = EntityServer.metaMap;
        Map columns = (Map)metaMap.get(tableName).get("columns");
        if (columns.containsKey("path") && columns != null) {
            String idNum = (String)metaMap.get(tableName).get("idColName");
            String selSql = "SELECT path FROM " + tableName + " WHERE " + idNum + "=" + idValue;
            try {
                JSONArray array = this.query(selSql);
                if (array.length() > 0) {
                    for (int i = 0; i < array.length(); ++i) {
                        JSONObject job = array.getJSONObject(i);
                        String filePath = job.get("path").toString();
                        if (filePath == null) continue;
                        Boolean bl = SqlServer.deleteFile(filePath);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean deleteFile(String filePath) {
        File file = new File(filePath);
        if (file.isFile() && file.exists()) {
            Boolean succeedDelete = file.delete();
            if (succeedDelete.booleanValue()) {
                System.out.println("\u5220\u9664" + filePath + "\u6210\u529f\uff01");
                return true;
            }
            System.out.println("\u5220\u9664" + filePath + "\u5931\u8d25\uff01");
            return true;
        }
        System.out.println("\u5220\u9664" + filePath + "\u5931\u8d25\uff01");
        return false;
    }

    public int runSQL(String sql) {
        Session session = this.assignedSession == null ? this.sessionFactory.getCurrentSession() : this.assignedSession;
        return SqlHelper.bulkSQLUpdate(session, sql);
    }

    public String call(String sqlName, JSONObject json) throws Exception {
        Map<String, Object> param = JsonHelper.toMap(json);
        return this.call(sqlName, param);
    }

    public String call(String sqlName, Map<String, Object> params) {
        String path = SqlMapper.getSql(sqlName);
        String sql = ResourceHelper.getString(path);
        sql = sql.replace("\r\n", "\n");
        sql = "$" + sql;
        params.put("sql", this);
        sql = ExpressionHelper.run(sql, params).toString();
        return sql;
    }

    public JSONArray hqlQuery(String name, JSONObject params) throws Exception {
        Map<String, Object> map = JsonHelper.toMap(params);
        String sql = this.call(name, map);
        Session session = this.assignedSession == null ? this.sessionFactory.getCurrentSession() : this.assignedSession;
        JSONArray array = SqlHelper.hqlQuery(session, sql);
        return array;
    }

    public JSONArray hqlQuery(String hql) throws Exception {
        Session session = this.assignedSession == null ? this.sessionFactory.getCurrentSession() : this.assignedSession;
        JSONArray array = SqlHelper.hqlQuery(session, hql);
        return array;
    }

    public JSONArray hqlQuery(String name, int pageNo, int pageSize, String str) throws Exception {
        if (pageNo <= 0) {
            pageNo = 1;
        }
        if (pageSize < 1 || pageSize > 1000) {
            pageSize = 1000;
        }
        JSONObject param = null;
        if (str != null && !str.isEmpty()) {
            param = new JSONObject(str);
            param = param.getJSONObject("data");
        }
        Map<String, Object> params = JsonHelper.toMap(param);
        return this.hqlQuery(name, pageNo, pageSize, params);
    }

    public JSONArray hqlQuery(String name, int pageNo, int pageSize, Map<String, Object> params) throws Exception {
        String sql = this.call(name, params);
        Session session = this.assignedSession == null ? this.sessionFactory.getCurrentSession() : this.assignedSession;
        JSONArray array = SqlHelper.hqlQuery(session, sql, pageNo - 1, pageSize);
        log.debug((Object)array.toString());
        return array;
    }

    private String filterOutOrderBy(String source, Object sums) throws Exception {
        int idx = source.toLowerCase().lastIndexOf("order by");
        String sql = "select ";
        if (sums != null) {
            if (sums instanceof JSONArray) {
                JSONArray arraySums = (JSONArray)sums;
                for (int i = 0; i < arraySums.length(); ++i) {
                    String name = (String)arraySums.get(i);
                    sql = sql + "sum(" + name + ") " + name + ", ";
                }
            } else if (sums instanceof JSONObject) {
                JSONObject objSums = (JSONObject)sums;
                Iterator keys = objSums.keys();
                while (keys.hasNext()) {
                    String name = (String)keys.next();
                    String value = objSums.getString(name);
                    sql = sql + "sum(" + value + ") " + name + ", ";
                }
            }
        }
        if (idx != -1) {
            sql = sql + "count(*) n, 1 placeholder from ( " + source.substring(0, idx) + ") t_";
        }
        return sql;
    }

    public JSONObject action(JSONObject params) {
        String Sql = params.getString("sql");
        log.debug((Object)Sql);
        this.run(Sql);
        JSONObject result = new JSONObject("{code: 200, data: {}}");
        return result;
    }
}

