/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.aote.sql.SqlServer;
import com.aote.util.AESUtil;
import com.aote.util.ExceptionHelper;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Path(value="sql")
@Component
@Transactional
public class SqlService {
    static Logger log = Logger.getLogger(SqlService.class);
    @Autowired
    private SqlServer sqlServer;

    @POST
    @Path(value="{name}/n")
    public String txgetTotalCnt(@PathParam(value="name") String name, String str) throws Exception {
        try {
            boolean shouldEecrypt = str.startsWith("$");
            if (shouldEecrypt) {
                str = AESUtil.aesDecrypt(str.substring(1));
            }
            JSONObject result = this.sqlServer.queryTotal(name, str);
            if (shouldEecrypt) {
                return result.toString();
            }
            return result.toString();
        }
        catch (Exception ex) {
            log.error((Object)ExceptionHelper.stackToString(ex));
            throw ex;
        }
    }

    @POST
    @Path(value="{name}")
    public String txExecute(@PathParam(value="name") String name, @QueryParam(value="pageNo") int pageNo, @QueryParam(value="pageSize") int pageSize, String str) throws Exception {
        try {
            boolean shouldEecrypt = str.startsWith("$");
            if (shouldEecrypt) {
                str = AESUtil.aesDecrypt(str.substring(1));
            }
            JSONArray result = this.sqlServer.query(name, pageNo, pageSize, str);
            if (shouldEecrypt) {
                return result.toString();
            }
            return result.toString();
        }
        catch (Exception ex) {
            log.error((Object)ExceptionHelper.stackToString(ex));
            throw ex;
        }
    }

    @POST
    @Path(value="hql/{name}/n")
    public String txHqlgetTotalCnt(@PathParam(value="name") String name, String str) throws Exception {
        try {
            boolean shouldEecrypt = str.startsWith("$");
            if (shouldEecrypt) {
                str = AESUtil.aesDecrypt(str.substring(1));
            }
            JSONObject result = this.sqlServer.queryHqlTotal(name, str);
            if (shouldEecrypt) {
                return result.toString();
            }
            return result.toString();
        }
        catch (Exception ex) {
            log.error((Object)ExceptionHelper.stackToString(ex));
            throw ex;
        }
    }

    @POST
    @Path(value="hql/{name}")
    public String txHqlExecute(@PathParam(value="name") String name, @QueryParam(value="pageNo") int pageNo, @QueryParam(value="pageSize") int pageSize, String str) throws Exception {
        try {
            boolean shouldEecrypt = str.startsWith("$");
            if (shouldEecrypt) {
                str = AESUtil.aesDecrypt(str.substring(1));
            }
            JSONArray result = this.sqlServer.hqlQuery(name, pageNo, pageSize, str);
            if (shouldEecrypt) {
                return result.toString();
            }
            return result.toString();
        }
        catch (Exception ex) {
            log.error((Object)ExceptionHelper.stackToString(ex));
            throw ex;
        }
    }
}

