/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.aote.logic.LogicServer;
import com.aote.rs.mapper.WebException;
import com.aote.util.AESUtil;
import com.aote.util.ExceptionHelper;
import com.aote.util.JsonTransfer;
import java.util.Map;
import javax.inject.Singleton;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Path(value="logic")
@Singleton
@Component
public class LogicService {
    static Logger log = Logger.getLogger(LogicService.class);
    @Autowired
    private LogicServer logicServer;

    @POST
    @Transactional
    @Path(value="{logic}")
    public String xtSave(@PathParam(value="logic") String logicName, String values) throws Exception {
        boolean shouldEecrypt = values.startsWith("$");
        if (shouldEecrypt) {
            values = AESUtil.aesDecrypt(values.substring(1));
        }
        log.debug((Object)("logic:" + logicName + ", values:" + values));
        try {
            String xml;
            JSONObject json;
            String xml2;
            Map map;
            JSONObject json2;
            Object result = this.logicServer.run(logicName, values);
            String resultEecrypt = result == null ? "" : (result instanceof Map ? (!(json2 = (JSONObject)new JsonTransfer().MapToJson(map = (Map)result)).isNull("xml") ? (xml2 = (String)json2.get("xml")) : json2.toString()) : (result instanceof JSONObject ? (!(json = (JSONObject)result).isNull("xml") ? (xml = json.getString("xml")) : json.toString()) : result.toString()));
            if (shouldEecrypt) {
                return resultEecrypt;
            }
            return AESUtil.aesEncrypt(resultEecrypt);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionHelper.stackToString(ex));
            WebException wex = this.getWebException(ex);
            if (wex != null) {
                throw wex;
            }
            throw ex;
        }
    }

    @POST
    @Path(value="noTransc/{logic}")
    public String save(@PathParam(value="logic") String logicName, String values) throws Exception {
        boolean shouldEecrypt = values.startsWith("$");
        if (shouldEecrypt) {
            values = AESUtil.aesDecrypt(values.substring(1));
        }
        log.debug((Object)("logic:" + logicName + ", values:" + values));
        try {
            String xml;
            JSONObject json;
            String xml2;
            Map map;
            JSONObject json2;
            Object result = this.logicServer.noTranscRun(logicName, values);
            String resultEecrypt = result == null ? "" : (result instanceof Map ? (!(json2 = (JSONObject)new JsonTransfer().MapToJson(map = (Map)result)).isNull("xml") ? (xml2 = (String)json2.get("xml")) : json2.toString()) : (result instanceof JSONObject ? (!(json = (JSONObject)result).isNull("xml") ? (xml = json.getString("xml")) : json.toString()) : result.toString()));
            if (shouldEecrypt) {
                return resultEecrypt;
            }
            return AESUtil.aesEncrypt(resultEecrypt);
        }
        catch (Exception ex) {
            log.error((Object)ExceptionHelper.stackToString(ex));
            WebException wex = this.getWebException(ex);
            if (wex != null) {
                throw wex;
            }
            throw ex;
        }
    }

    private WebException getWebException(Exception ex) {
        for (Throwable cause = ex; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof WebException)) continue;
            return (WebException)cause;
        }
        return null;
    }
}

