/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.aote.entity.EntityServer;
import com.aote.module.ModuleMapper;
import com.aote.sql.SqlServer;
import com.aote.util.ResourceHelper;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Path(value="file")
@Component
@Transactional
public class FileService {
    static Logger log = Logger.getLogger(FileService.class);
    @Autowired
    private SessionFactory sessionFactory;
    @Autowired
    private EntityServer entityServer;
    @Autowired
    private SqlServer sqlServer;

    private static byte[] subBytes(byte[] b, int from, int end) {
        byte[] result = new byte[end - from];
        System.arraycopy(b, from, result, 0, end - from);
        return result;
    }

    private static int locateEnd(byte[] bytes, int start, int end, String endStr) {
        byte[] endByte = endStr.getBytes();
        for (int i = start + 1; i < end; ++i) {
            int k;
            if (bytes[i] != endByte[0]) continue;
            for (k = 1; k < endByte.length && bytes[i + k] == endByte[k]; ++k) {
            }
            if (i == 3440488) {
                System.out.println("start");
            }
            if (k != endByte.length) continue;
            return i;
        }
        return 0;
    }

    @POST
    @Path(value="upload")
    public String fileUpload(@Context HttpServletRequest request, @Context HttpServletResponse response) throws Exception {
        String realpath = this.getPath("uploadFilepath");
        JSONObject result = new JSONObject();
        File file = new File(realpath + File.separator + this.getNowDate());
        if (!file.exists()) {
            file.mkdirs();
        }
        String downloadpath = "";
        String username = URLDecoder.decode(request.getHeader("username"), "UTF-8");
        String blodid = request.getHeader("blodid");
        downloadpath = this.getPath("downloadpath");
        System.out.println(downloadpath);
        System.out.println(username);
        System.out.println(blodid);
        System.out.println(realpath);
        int totalBytes = request.getContentLength();
        System.out.println("\u5f53\u524d\u6570\u636e\u603b\u957f\u5ea6:" + totalBytes);
        String contentType = request.getContentType();
        System.out.println(contentType);
        int position = contentType.indexOf("boundary=");
        String startBoundary = "--" + contentType.substring(position + "boundary=".length());
        String endBoundary = startBoundary + "--";
        ServletInputStream inputStream = request.getInputStream();
        DataInputStream dataInputStream = new DataInputStream((InputStream)inputStream);
        byte[] bytes = new byte[totalBytes];
        dataInputStream.readFully(bytes);
        dataInputStream.close();
        BufferedReader reader = new BufferedReader(new StringReader(new String(bytes)));
        int temPosition = 0;
        boolean flag = false;
        int end = 0;
        while (true) {
            if (flag) {
                bytes = FileService.subBytes(bytes, end, totalBytes);
                temPosition = 0;
                reader = new BufferedReader(new StringReader(new String(bytes)));
            }
            String str = reader.readLine();
            System.out.println("this line is:" + str);
            temPosition += str.getBytes().length + 2;
            if (str == null || str.equals(endBoundary)) break;
            if (!str.startsWith(startBoundary)) continue;
            str = reader.readLine();
            temPosition += str.getBytes().length + 2;
            int position1 = str.indexOf("filename=");
            if (position1 == -1) continue;
            int position2 = str.indexOf("name=");
            String name = str.substring(position2 + "name=".length() + 1, position1 - 3);
            String filename = str.substring(position1 + "filename=".length() + 1, str.length() - 1);
            filename = new String(filename.getBytes(), "utf-8");
            String uploaddate = this.getDate();
            filename = filename.split("\\.")[0] + "_" + username + "_" + uploaddate + "." + filename.split("\\.")[1];
            System.out.println(filename);
            end = FileService.locateEnd(bytes, temPosition += reader.readLine().getBytes().length + 4, totalBytes, endBoundary);
            DataOutputStream dOutputStream = new DataOutputStream(new FileOutputStream(new File(file.getAbsolutePath() + File.separator + filename)));
            dOutputStream.write(bytes, temPosition, end - temPosition - 2);
            dOutputStream.close();
            flag = true;
            downloadpath = file.getAbsolutePath() + File.separator + filename;
            String filetype = filename.split("\\.")[1];
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("f_filename", filename);
            map.put("f_username", username);
            map.put("f_uploaddate", uploaddate);
            map.put("f_blobid", blodid);
            map.put("f_filetype", filetype);
            map.put("f_downloadpath", downloadpath);
            map.put("f_realpath", realpath);
            this.entityServer.save("t_files", map);
        }
        result.put("path", (Object)downloadpath);
        result.put("result", (Object)"success");
        System.out.println("1111111111" + result.toString());
        return result.toString();
    }

    @Path(value="savefile")
    @POST
    public String savefile(byte[] file, @QueryParam(value="filename") String filename, @QueryParam(value="module") String module) {
        try {
            String realpath = ModuleMapper.getAttr(module, "upload");
            realpath = this.getRealPath(realpath) + File.separator + filename;
            DataOutputStream dOutputStream = new DataOutputStream(new FileOutputStream(new File(realpath)));
            dOutputStream.write(file);
            dOutputStream.close();
            String filetype = filename.split("\\.")[1];
            JSONObject map = new JSONObject();
            map.put("f_filename", (Object)filename);
            String uploaddate = this.getDate();
            map.put("f_uploaddate", (Object)uploaddate);
            map.put("f_filetype", (Object)filetype);
            map.put("f_realpath", (Object)realpath);
            JSONObject result = new JSONObject(this.entityServer.partialSave("t_files", map));
            String ret = result.getString("id");
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Path(value="getfile/{blobid}")
    @GET
    public byte[] getfile(@PathParam(value="blobid") String blobid) {
        try {
            JSONArray array = this.sqlServer.query("select f_realpath from t_files where id=" + blobid);
            if (array.length() == 0) {
                return null;
            }
            JSONObject map = array.getJSONObject(0);
            String filename = map.getString("f_realpath");
            File file = new File(filename);
            FileInputStream in = new FileInputStream(file);
            byte[] result = new byte[(int)file.length()];
            in.read(result);
            return result;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void transformStream(InputStream is, OutputStream os) {
        try {
            byte[] buffer = new byte[1024];
            int length = is.read(buffer);
            while (length != -1) {
                os.write(buffer, 0, length);
                length = is.read(buffer);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getRealPath(String realpath) {
        Date d = new Date();
        realpath = realpath + File.separator + (d.getYear() + 1900) + File.separator + (d.getMonth() + 1) + File.separator + d.getDate();
        File f = new File(realpath);
        try {
            if (!f.exists()) {
                f.mkdirs();
            }
            return realpath;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getNowDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(new Date());
    }

    public String getDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        return sdf.format(new Date());
    }

    public String getPath(String pathname) throws IOException {
        String proPath = System.getProperty("user.dir");
        System.out.println(proPath);
        Properties pro = new Properties();
        FileInputStream in = new FileInputStream(proPath + "\\file.properties");
        pro.load(in);
        String path = pro.getProperty(pathname);
        System.out.println(path);
        in.close();
        return path;
    }

    @POST
    @Path(value="deleteFile")
    public String deleteFile(@Context HttpServletRequest request, @Context HttpServletResponse response) throws JSONException, IOException {
        request.setCharacterEncoding("utf-8");
        JSONObject obj = new JSONObject(new JSONTokener((InputStream)request.getInputStream()));
        System.out.println(obj.toString());
        String path = new String(obj.getString("path").getBytes(), "utf-8");
        String blobid = obj.getString("blobid");
        System.out.println(path);
        path.split("/");
        System.out.println(blobid);
        File file = new File(path);
        if (file.exists()) {
            file.delete();
            Session session = this.sessionFactory.openSession();
            Query query = session.createQuery("delete from t_files where blobid='" + blobid + "' and " + "filename='" + path.split("/")[path.split("/").length - 1] + "'");
            query.executeUpdate();
            if (session != null) {
                session.close();
            }
            System.out.println("success");
            return "success";
        }
        System.out.println("file is not exists");
        return "file is not exists";
    }

    @GET
    @Path(value="vue/{filename}")
    public String getVueFile(@PathParam(value="filename") String fileName) {
        log.debug((Object)fileName);
        String source = ResourceHelper.getString("/vue/" + fileName);
        return source;
    }
}

