/*
 * Decompiled with CFR 0.152.
 */
package com.aote.path;

import com.aote.entity.EntityServer;
import com.aote.path.PathHelper;
import com.aote.path.PathMapper;
import com.aote.util.ExpressionHelper;
import com.aote.util.JsonHelper;
import com.aote.util.ResourceHelper;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PathServer {
    static Logger log = Logger.getLogger(PathServer.class);
    @Autowired
    public SessionFactory sessionFactory;
    public Session assignedSession;

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setAssignedSession(Session session) {
        this.assignedSession = session;
    }

    public JSONArray query(String name, JSONObject params) {
        return this.query(name, params.toString());
    }

    public JSONArray query(String name, String str) {
        try {
            JSONObject json;
            JSONObject param = null;
            if (str != null && !str.isEmpty() && (json = new JSONObject(str)).has("data")) {
                param = json.getJSONObject("data");
            }
            Map<String, Object> params = JsonHelper.toMap(param);
            String path = this.call(name, params);
            Session session = this.assignedSession == null ? this.sessionFactory.getCurrentSession() : this.assignedSession;
            JSONArray array = PathHelper.query(session, path);
            return array;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject queryTotal(String name, String str) throws Exception {
        JSONObject json;
        JSONObject param = null;
        if (str != null && !str.isEmpty() && (json = new JSONObject(str)).has("data")) {
            param = json.getJSONObject("data");
        }
        Map<String, Object> params = JsonHelper.toMap(param);
        String path = this.call(name, params);
        path = this.filterOutOrderBy(path);
        Session session = this.assignedSession == null ? this.sessionFactory.getCurrentSession() : this.assignedSession;
        JSONArray array = PathHelper.query(session, path);
        return array.getJSONObject(0);
    }

    public JSONArray query(String name, int pageNo, int pageSize, String str) throws Exception {
        if (pageNo <= 0) {
            pageNo = 1;
        }
        if (pageSize < 1) {
            pageSize = 1000;
        }
        JSONObject param = null;
        if (str != null && !str.isEmpty()) {
            param = new JSONObject(str);
            param = param.getJSONObject("data");
        }
        Map<String, Object> params = JsonHelper.toMap(param);
        return this.query(name, pageNo, pageSize, params);
    }

    public JSONArray query(String name, int pageNo, int pageSize, Map<String, Object> params) throws Exception {
        String sql = this.call(name, params);
        Session session = this.assignedSession == null ? this.sessionFactory.getCurrentSession() : this.assignedSession;
        String tableName = this.getTableName(sql);
        EntityServer entityServer = new EntityServer();
        HashMap<String, HashMap<String, Object>> metaMap = EntityServer.metaMap;
        String tableId = (String)metaMap.get(tableName).get("idColName");
        String findId = this.searchIdSql(sql, tableName, tableId);
        try {
            JSONArray idArray = PathHelper.query(session, findId, pageNo - 1, pageSize);
            log.debug((Object)idArray.toString());
            String res = this.getIdList(idArray, tableId);
            JSONArray array = new JSONArray();
            if (!"".equals(res)) {
                String replace = "[" + tableId + " in (" + res + ")].(\n";
                String sqlRes = this.querySql(sql, replace);
                array = PathHelper.query(session, sqlRes);
                return array;
            }
            return array;
        }
        catch (RuntimeException e) {
            log.error((Object)("path: " + name + "\u51fa\u9519\uff0c\u539f\u56e0 \uff1a" + e.getMessage()));
            throw e;
        }
    }

    public String getIdList(JSONArray idArray, String tableId) {
        log.debug((Object)"start into getIdList");
        String result = "";
        if (idArray.length() > 0) {
            for (int j = 0; j < idArray.length(); ++j) {
                JSONObject job = idArray.getJSONObject(j);
                result = job.get(tableId) instanceof String ? result + "'" + job.get(tableId).toString() + "'" : result + job.get(tableId).toString();
                if (j >= idArray.length() - 1) continue;
                result = result + ",";
            }
        }
        return result;
    }

    public String searchIdSql(String sql, String tableName, String tableId) {
        String resSql = "";
        BufferedReader reader = new BufferedReader(new StringReader(sql));
        try {
            String line = reader.readLine();
            reader.close();
            resSql = StringUtils.substringBeforeLast((String)line, (String)".") + ".(" + tableId + ")";
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return resSql;
    }

    public String querySql(String sql, String replaceStr) {
        String resSql = "";
        BufferedReader reader = new BufferedReader(new StringReader(sql));
        try {
            String line = reader.readLine();
            resSql = line.replaceFirst("\\.\\(", replaceStr);
            while ((line = reader.readLine()) != null) {
                resSql = resSql + "\n" + line;
            }
            reader.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return resSql;
    }

    public String getTableName(String sql) {
        String tableName = null;
        BufferedReader reader = new BufferedReader(new StringReader(sql));
        try {
            String line = reader.readLine();
            reader.close();
            tableName = line.indexOf("[") == -1 ? StringUtils.substringBefore((String)line, (String)".(") : StringUtils.substringBefore((String)line, (String)"[");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return tableName;
    }

    public String call(String name, Map<String, Object> params) {
        String path = PathMapper.getPath(name);
        String sql = ResourceHelper.getString(path);
        sql = sql.replace("\r\n", "\n");
        sql = "$" + sql;
        params.put("sql", this);
        sql = ExpressionHelper.run(sql, params).toString();
        return sql;
    }

    private String filterOutOrderBy(String source) {
        BufferedReader reader = new BufferedReader(new StringReader(source));
        try {
            String line = reader.readLine();
            reader.close();
            int index = line.lastIndexOf(46);
            String result = line.substring(0, index) + ".(count(*) n, group(null))";
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JSONArray query(String sql) {
        Session session = this.assignedSession == null ? this.sessionFactory.getCurrentSession() : this.assignedSession;
        try {
            return PathHelper.query(session, sql);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject action(JSONObject params) {
        String path = params.getString("alias");
        JSONObject data = params.getJSONObject("data");
        JSONObject param = new JSONObject();
        param.put("data", (Object)data);
        JSONArray array = this.query(path, param);
        JSONObject result = new JSONObject("{code: 200}");
        result.put("data", (Object)array);
        return result;
    }
}

