package com.aote.util;

import java.io.IOException;
import java.io.InputStream;

public class ResourceHelper {

	/**
	 * 获取资源文件里，指定全路径文件的文本内容
	 * 
	 * @param fileName
	 *            : 以'/'开始的资源文件的全路径文件名
	 * @return: 文件的文本内容
	 */
	public static String getString(String fileName) {
		String result = null;
		InputStream inputStream = null;
		try {
			inputStream = ResourceHelper.class.getResourceAsStream("/"+fileName);
			if(null == inputStream){
				throw new RuntimeException(fileName + ".文件不存在");
			}
			byte[] b = new byte[1024];  
			int len = 0;  
			StringBuilder sb = new StringBuilder(); 
			while ((len = inputStream.read(b)) != -1) {   
                sb.append(new String(b, 0, len, "UTF-8"));   
            }
			result = sb.toString();
		}catch(NullPointerException e){
			throw new NullPointerException(fileName + ".文件无配置");
		}catch (RuntimeException e) {
			throw e;
		}catch (Exception e) {
			throw new RuntimeException(e);
		}finally {
			try {
				if(null != inputStream){
					inputStream.close();
				}
			} catch (IOException e) {
				e.printStackTrace();
			} 
		}
		return result;
	}
}
