package com.aote.timer;

import java.util.ArrayList;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;

import com.aote.sql.SqlServer;

/**
 * SQL源
 * 
 * @author 111
 *
 */
public class SQLSource implements ISource {

	@Autowired
	private SqlServer sqlServer;

	private List<String> sqls;

	@Override
	public Object getSource() {
		System.out.println("sql名字为" + sqls);
		List<JSONArray> list = new ArrayList<JSONArray>();
		for (int i = 0; i < sqls.size(); i++) {
			String sql = sqls.get(i);
			JSONArray ja = null;
			try {
				ja = sqlServer.query(sql, new JSONObject());
				if (ja == null) {
					continue;
				}
				list.add(ja);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return list;

	}
	
//	public static void main(String[] args) {
//		sqls = new ArrayList<String>();
//		sqls.add("nihao");
//		List<JSONArray> source = (List<JSONArray>) new SQLSource().getSource();
//		System.out.println(source);
//		System.out.println(source != null);
//		System.out.println(source.size());
//	}
	
	public List<String> getSqls() {
		return sqls;
	}

	public void setSqls(List<String> sqls) {
		this.sqls = sqls;
	}
}
