package com.aote.rs;

import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.ws.rs.POST;
import javax.ws.rs.Path;

import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import com.aote.entity.EntityServer;
import com.aote.path.PathServer;
import com.aote.sql.SqlServer;
import com.aote.util.ResourceHelper;

@Path("product")
@Singleton
@Component
public class ProductService {
	static Logger log = Logger.getLogger(ProductService.class);

	@Autowired
	private EntityServer entityServer;

	@Autowired
	private SqlServer sqlServer;

	@Autowired
	private PathServer pathServer;

	/**
	 * 取正在运行系统的参数，存放到c:/param.json中
	 * @return 无
	 * @throws Exception
	 */
	@POST
	@Transactional
	@Path("getparam")
	public String xtGetParam() throws Exception {
		// 执行path查询，找到所有参数
		String path = "t_parameter.(**)";
		JSONArray array = pathServer.query(path);
		// 获取单值表
		String getSingle = "t_singlevalue.(*)";
		JSONArray singles = pathServer.query(getSingle);
		// 打开c:/param.json
		Writer writer = new OutputStreamWriter(new FileOutputStream("d:/param.json"), "utf-8");
		writer.write("{\n");
		
		// 把查询到的json转换成要写的json对象
		for (Object o : array) {
			JSONObject param = (JSONObject)o;
			String key = param.getString("name");
			JSONArray paramValue = new JSONArray();
			JSONArray paramArray = param.getJSONArray("f_paramvalues");
			for(Object obj : paramArray) {
				JSONObject paramJson = (JSONObject)obj;
				String value = paramJson.getString("name");
				paramValue.put(value);
			}
			// 输出一个参数值
			String result = "\t\"" + key + "\":" + paramValue.toString() + ",\n";
			writer.write(result);
		}
		for (Object o : singles) {
			JSONObject param = (JSONObject)o;
			String key = param.getString("name");
			String value = param.getString("value");
			// 输出一个参数值
			String result = "\t\"" + key + "\":" + value + ",\n";
			writer.write(result);
		}
		
		writer.write("}\n");
		writer.close();
		return "";
	}
	
	@PostConstruct
	public void init() throws Exception {
		entityServer.initParam();
	}
}
