package com.aote.module;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import com.aote.logic.LogicMapper;

public class ModuleMapper {

	static Logger log = Logger.getLogger(LogicMapper.class);

	private static Map<String, Map<String, String>> map;

	public static synchronized String getAttr(String module, String attr) {
		if (map == null)
			loadMap();
		if (map.containsKey(module))
			return map.get(module).get(attr);
		else
			return null;
	}

	@SuppressWarnings("rawtypes")
	private static void loadMap() {
		map = new HashMap<String, Map<String, String>>();

		SAXReader reader = new SAXReader();
		InputStream module = LogicMapper.class.getClassLoader()
				.getResourceAsStream("module.xml");
		try {
			if (module == null) {
				throw new RuntimeException("模块定义文件module.xml未找到");
			}
			parseModule(module);
		} catch (Exception ex) {
			throw new RuntimeException(ex);
		}

	}

	private static void parseModule(InputStream input) throws Exception {
		SAXReader reader = new SAXReader();
		Document document = reader.read(input);
		Element root = document.getRootElement();
		for (Iterator it = root.elementIterator("module"); it.hasNext();) {
			Element elm = (Element) it.next();
			String name = elm.attribute("name").getValue();
			String upload = elm.attributeValue("upload");
			// 设置module属性
			Map<String, String> module = new HashMap<String, String>();
			module.put("name", name);
			module.put("upload", upload);
			map.put(name, module);
		}
	}
}
