package com.aote.manager;

import java.io.InputStream;
import java.util.Iterator;

import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.json.JSONArray;
import org.json.JSONObject;

public class SQLServer {
	public JSONArray getData() {
		JSONArray result = new JSONArray();
		
		SAXReader reader = new SAXReader();
		InputStream input = SQLServer.class.getClassLoader().getResourceAsStream("sql.xml");
		try {
			// 到session-factory节点
			Document document = reader.read(input);
			Element root = document.getRootElement();

			// 保存找到的最近的未匹配内容的注释
			JSONObject item = null;
			
			// 对于root的每一个子节点
			for (Iterator it = root.nodeIterator(); it.hasNext();) {
				Node node = (Node) it.next();
				// 如果是注释，对注释进行处理
				if (node instanceof Comment) {
					Comment comment = (Comment)node;
					JSONObject json = this.getJSON(comment);
					if (json != null) {
						item = json;
					}
				} 
				// 是节点，对节点进行处理
				else if (node instanceof Element) {
					Element element = (Element)node;
					// 如果没有注释，产生空注释
					if (item == null) {
						item = new JSONObject();
						item.put("summery", "");
					}
					this.procElement(element, item);
					result.put(item);
					item = null;
				}
			}
			
			return result;
		} catch (DocumentException ex) {
			throw new RuntimeException(ex);
		}
	}
	
	// 对注释进行处理，从注释中获取说明，注释以@+json串方式开始，json串格式为：{summery: 'SQL说明'}
	private JSONObject getJSON(Comment comment) {
		String text = comment.getText();
		JSONObject json = new JSONObject();
		json.put("summery", text);
		return json;
	}
	
	// 对找到的节点进行处理, 向注释对应的JSON中添加名称及内容
	private void procElement(Element element, JSONObject json) {
		// 不是mapping, 返回空
		if (!element.getName().equals("sql")) {
			return;
		}
		String name = element.attributeValue("alias");
		json.put("name", name);
		String path = element.attributeValue("path");
		json.put("text", "路径: " + path);
	}
}
