select *
from (select
             isnull(uf.f_yc_meter_base, 0)                                                               f_last_tablebase,
             ychand.f_hand_date                                                                              f_last_input_date,
             uf.f_orgid,
             uf.f_table_state,
             uf.f_filialeid,
             uf.f_user_id,
             uf.f_meternumber,
             uf.f_userfiles_id,
             uf.f_user_type,
             uf.f_gasproperties,
             uf.f_price_id,
             uf.f_inputtor,
             uf.f_meter_book_sort,
             u.f_userinfo_id,
             u.f_userinfo_code,
             u.f_user_name,
             u.f_user_phone,
             u.f_balance,
             u.f_user_state,
             u.f_comments                                                                                f_phone_comments, --备注
             ua.f_address,
             uf.f_meter_classify,
             ua.f_residential_area,
             ua.f_building,
             ua.f_unit,
             ua.f_floor,
             ua.f_room,
             ua.f_last_check_date                                                                        f_last_checkdate,
             gb.f_meter_brand,
             isnull(uf.f_total_gas, 0)                                                                   f_total_gas,
             isnull(uf.f_initial_base, 0)                                                                f_initial_base,
             uf.version,
             gm.f_meter_style,
             mb.id                                                                                       mbid,
             mb.f_book_name,
             ad.f_adjustable_name,
             ad.f_adjustable_id,
             h1.maxid,
             sp.id f_stairprice_id,
             ychand.id f_last_handid,
             ychand.f_notified_path f_last_notified1,
             ychand.f_notified2_path f_last_notified2,
             ychand.f_notified3_path f_last_notified3
      from t_userfiles uf
               left join t_user_address ua on uf.f_useraddress_id = ua.id
               left join t_userinfo u on u.f_userinfo_id = uf.f_userinfo_id
               left join t_gasbrand gb on uf.f_gasbrand_id = gb.id
               left join t_gasmodel gm on uf.f_gasmodel_id = gm.id
               left join t_meter_book mb on uf.f_meter_book_num = mb.id
               left join (select f_userfiles_id,
                                 max(id) maxid
                          from t_yccustom_handplan
                          where f_hand_state = '有效'
                            and f_meter_state = '已抄表'
                          group by f_userfiles_id
                ) h1 on uf.f_userfiles_id = h1.f_userfiles_id
               left join (select *
                          from t_stairprice
                          where getdate() >= f_perform_date and getdate() <= f_end_date and f_state = '有效') sp
                         on uf.f_price_id = sp.f_price_id
               left join t_yccustom_handplan ychand on ychand.id = h1.maxid
               left join t_area a on ua.f_residential_area_id = a.id
               left join t_adjustablebox ad on uf.f_adjustable_id = ad.id) t
where {condition}
  and f_meter_classify != '机表'
  and f_table_state = '正常'
  and f_user_state = '正常'
  and f_price_id in ('39','40')
order by
    f_address asc


