select
    *
from
    (
        select
            h.*,
            hd.f_stair1amount,
            hd.f_stair1price,
            hd.f_stair1fee,
            hd.f_stair2amount,
            hd.f_stair2price,
            hd.f_stair2fee,
            hd.f_stair3amount,
            hd.f_stair3price,
            hd.f_stair3fee,
            hd.f_cycleamount,
            hd.f_cyclefee,
            hd.f_cycleprice,
            ua.f_zones
        from
            t_cardhand h
            left join (
                select
                    f_hand_id f_hand_id,
                    sum ( case f_price_name when '跨周期气价' then f_gas end ) f_cycleamount,
                    sum ( case f_price_name when '跨周期气价' then f_price end ) f_cycleprice,
                    sum ( case f_price_name when '跨周期气价' then f_money end ) f_cyclefee,
                    sum ( case f_price_name when '阶梯1' then f_gas when '固定气价' then f_gas else 0 end ) f_stair1amount,
                    sum ( case f_price_name when '阶梯1' then f_price when '固定气价' then f_price else 0 end ) f_stair1price,
                    sum ( case f_price_name when '阶梯1' then f_money when '固定气价' then f_money else 0 end ) f_stair1fee,
                    sum ( case f_price_name when '阶梯2' then f_gas else 0 end ) f_stair2amount,
                    sum ( case f_price_name when '阶梯2' then f_price else 0 end ) f_stair2price,
                    sum ( case f_price_name when '阶梯2' then f_money else 0 end ) f_stair2fee,
                    sum ( case f_price_name when '阶梯3' then f_gas else 0 end ) f_stair3amount,
                    sum ( case f_price_name when '阶梯3' then f_price else 0 end ) f_stair3price,
                    sum ( case f_price_name when '阶梯3' then f_money else 0 end ) f_stair3fee
                from
                    t_cardchargeprice
                where
                    f_hand_id is not null
                group by
                    f_hand_id
            ) hd on hd.f_hand_id= h.id
            left join ( select f_slice_area as f_zones, f_userinfo_id from t_user_address ) ua on h.f_userinfo_id= ua.f_userinfo_id
    ) t
where
    { condition }
order by
    f_hand_date desc
