select * from (
    SELECT
        isnull(uf.f_meter_base,0) f_last_tablebase,
        uf.f_hand_date f_last_input_date,
        uf.f_orgid,
        uf.f_table_state,
        uf.f_filialeid,
        uf.f_user_id,
        case when isnull(uf.f_capacity, 0) > 0 then uf.f_capacity else gm.f_capacity end f_capacity, --表最大量程
        uf.f_meternumber,
        uf.f_userfiles_id,
        uf.f_user_type,
        uf.f_gasproperties,
        uf.f_price_id,
        uf.f_inputtor,
        uf.f_meter_book_sort,
        u.f_userinfo_id,
        u.f_userinfo_code,
        u.f_user_name,
        u.f_user_phone,
        u.f_balance,
        u.f_user_state,
        u.f_user_level,    --用户等级
        u.f_rent_phone,  --备用电话
        u.f_book_no,
        u.f_comments f_phone_comments, --备注
        ua.f_address,
        ua.f_residential_area,
        ua.f_building,
        ua.f_unit,
        ua.f_floor,
        ua.f_room,
        ua.f_last_check_date f_last_checkdate,
        gb.f_meter_brand,
        uf.f_meter_classify,
        isnull(uf.f_total_gas,0) f_total_gas,
        isnull(uf.f_initial_base,0) f_initial_base,
        isnull(uf.f_total_usegas_amount,0) f_total_usegas_amount,
        uf.version,
        gm.f_meter_style,
        mb.id mbid,
        mb.f_book_name,
        ad.f_adjustable_name,
        ad.f_adjustable_id,
		h3.f_last_result_state,
        isnull( h3.f_last_startbase, 0 ) f_last_startbase,
        isnull( h3.f_last_gas, 0 ) f_last_gas,
        isnull(f_last_shengyu_gas, 0 ) f_last_shengyu_gas,
        isnull(h3.f_last_oughtamount, 0 ) f_last_oughtamount,
        isnull( a2.f_ave_gas, 0 ) f_ave_gas
    FROM
        t_userfiles uf
        LEFT JOIN t_user_address ua ON uf.f_useraddress_id = ua.id
        LEFT JOIN t_userinfo u ON u.f_userinfo_id = uf.f_userinfo_id
        left join t_gasbrand gb on uf.f_gasbrand_id = gb.id
        left join t_gasmodel gm on uf.f_gasmodel_id=gm.id
        left join t_meter_book mb on uf.f_meter_book_num=mb.id
        left join (
            select f_userfiles_id,
            max(id) maxid,
            { entity.findDialect() == $SqlServer$:$
            cast(max(f_tablebase)/count(*) as   numeric(9,2))
            $,$
            ROUND(max(f_tablebase)/count(*),2)
            $}
           f_ave_gas
            from
                t_cardhand
            where
                f_meter_state='已抄表'
            group by
                f_userfiles_id
        ) a2 on uf.f_userfiles_id=a2.f_userfiles_id
        left join (select id,f_real_amount as f_last_oughtamount,f_shengyu_gas as f_last_shengyu_gas,f_last_tablebase f_last_startbase,f_real_amount f_last_gas,f_result_state f_last_result_state from t_cardhand)h3 on a2.maxid=h3.id
        left join t_area a on ua.f_residential_area_id = a.id
        LEFT JOIN t_adjustablebox ad ON uf.f_adjustable_id = ad.id
    )t
where {condition} AND f_table_state = '正常' and f_user_state='正常'
order by f_book_name,f_meter_book_sort,f_adjustable_id,mbid,f_address {sort}


