/*
 * Decompiled with CFR 0.152.
 */
package product;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.type.StandardBasicTypes;

public class MySqlServerDialect2
extends SQLServerDialect {
    public MySqlServerDialect2() {
        this.registerHibernateType(-15, StandardBasicTypes.CHARACTER.getName());
        this.registerHibernateType(-15, 1L, StandardBasicTypes.CHARACTER.getName());
        this.registerHibernateType(-15, 255L, StandardBasicTypes.STRING.getName());
        this.registerHibernateType(-9, StandardBasicTypes.STRING.getName());
        this.registerHibernateType(-16, StandardBasicTypes.TEXT.getName());
        this.registerHibernateType(2011, StandardBasicTypes.CLOB.getName());
    }

    static int getLastIndexOfOrderBy(String sql) {
        Pattern pattern = Pattern.compile("order\\s+by\\s+", 2);
        Matcher matcher = pattern.matcher(sql);
        int index = -1;
        while (matcher.find()) {
            index = matcher.start();
        }
        return index;
    }

    public String getLimitString(String querySelect, int offset, int limit) {
        int lastIndexOfOrderBy = MySqlServerDialect2.getLastIndexOfOrderBy(querySelect);
        if (lastIndexOfOrderBy < 0 || querySelect.endsWith(")") || offset == 0) {
            return super.getLimitString(querySelect, 0, limit);
        }
        String orderby = querySelect.substring(lastIndexOfOrderBy);
        int indexOfFrom = querySelect.toLowerCase().indexOf("from");
        String selectFld = querySelect.substring(0, indexOfFrom);
        String selectFromTableAndWhere = querySelect.substring(indexOfFrom, lastIndexOfOrderBy);
        String sql = "SELECT * FROM (" + selectFld + ",ROW_NUMBER() OVER(" + orderby + ") AS _page_row_num_hb " + selectFromTableAndWhere + " ) temp " + " WHERE _page_row_num_hb BETWEEN " + (offset + 1) + " AND " + limit;
        return sql;
    }

    public boolean supportsLimitOffset() {
        return true;
    }
}

