package com.aote.rs;

import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

/**
 * 对工单进行处理的插件，前后台都用
 */
public class MobileServicePlugin {
	private static Logger log = Logger.getLogger(MobileServicePlugin.class);

	// 根据前台传过来的一批工单编号，以及查询到的待办工单内容，返回新增工单/删除工单/修改工单结果
	// androids: 安卓端未完成的工单列表，JSON串, 格式: [{id: 安卓端id, id_back: pc端工单 id,
	// service_version: 版本号}]
	// pcs: pc端查找到的未处理完的工单，JSON串， 格式：[{完整工单内容，service_version:版本号, 故障信息}]
	// 返回结果: json对象，格式 {inserts: [新增工单], deletes: [{id_back: 工单 id}], modifies:
	// [修改工单]}
	public JSONObject getChanged(JSONArray androids, JSONArray pcs) {
		log.debug("androids:"+androids);
		log.debug("pcs:"+pcs);
		JSONArray inserts = new JSONArray();
		JSONArray deletes = new JSONArray();
		JSONArray modifies = new JSONArray();
		JSONObject result = new JSONObject();
		JSONObject row = null;

		result.put("inserts", inserts);
		result.put("deletes", deletes);
		result.put("modifies", modifies);


		JSONArray noDeletes = new JSONArray();
		try {
			for (Object pcObj : pcs) {
				// 如果pc端工单不包含在安卓端，新增
				JSONObject pc = (JSONObject) pcObj;
				JSONObject android = this.getService(androids, "id", pc, "id");
				if (android == null) {
					inserts.put(pc);
				} else {
					noDeletes.put(android);
				}
			}
			// 安卓端工单去掉pc端已包含的，就是要删除的
			for (Object o : androids) {
				JSONObject android = (JSONObject) o;
				JSONObject json = this.getService(noDeletes, "id", android, "id");
				if (json == null) {
					row = new JSONObject();
					row.put("id", android.getInt("id"));
					deletes.put(row);
				}
			}
		}catch(Exception e){
			log.error("错误：" + e.toString());
			e.printStackTrace();
		}
		return result;
	}


	/**
	 * 从工单集合中，获取与给定工单id相同的工单
	 *
	 * @param array
	 *            工单集合
	 * @param arrayId
	 *            工单集合里的工单id名
	 * @param json
	 *            要查看的工单
	 * @param jsonId
	 *            要查看的工单的id名
	 * @return 工单集合里的工单，没有，返回空
	 */
	private JSONObject getService(JSONArray array, String arrayId,
			JSONObject json, String jsonId) {
		for (Object o : array) {
			JSONObject otherJson = (JSONObject) o;
			if (otherJson.getInt(arrayId) == json.getInt(jsonId)) {
				return otherJson;
			}
		}
		return null;
	}
}
