package com.af.plugins.timeoutReturn;

import com.aote.redis.RedisUtil;
import org.json.JSONObject;
import org.springframework.stereotype.Component;


/**
 * 针对前台超时，需要获取返回信息工具
 */
@Component
public class TimeCacheNew {
    private RedisUtil redisUtil = RedisUtil.getInstance();
    public TimeCacheNew() {

    }

    /**
     * redis缓存值
     * @param key
     * @param value
     * @param timeout
     * @throws Exception
     */
    public void setCahce(String key,JSONObject value,int timeout) throws Exception {
        if(key == null || "".equals(key) || value == null){
            throw new Exception("key或value传参为null无法进行缓存");
        }
        if(timeout<=0){
            timeout = 30*60;
            redisUtil.set(key,value.toString(),timeout);
        }else{
            redisUtil.set(key,value.toString(),timeout);
        }
    }

    /**
     * redis缓存值
     * @param key
     * @param value
     * @throws Exception
     */
    public void setCahce(String key,JSONObject value) throws Exception {
        if(key == null || "".equals(key) || value == null){
            throw new Exception("key或value传参为null无法进行缓存");
        }
        redisUtil.set(key,value.toString());
    }

    /**
     * redis获取值
     * @param key
     * @return
     * @throws Exception
     */
    public JSONObject getCache(String key) throws Exception {
        if(key == null || "".equals(key) ){
            throw new Exception("key或value传参为null无法进行缓存");
        }
        String value = (String) redisUtil.get(key);
        return new JSONObject(value);
    }
}
