package com.af.plugins.timeoutReturn;

import com.aote.config.SystemConfig;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.stereotype.Component;
import redis.clients.jedis.*;

@Component
public class RedisCacheTools {
    private static Logger log = Logger.getLogger(RedisCacheTools.class);
    private static JedisPool jedisPool;
    private static final JedisPoolConfig config = new JedisPoolConfig();

    public RedisCacheTools() {
    }

    public void getJedisPool(String host, int port) {
        jedisPool = new JedisPool(config, host, port);
    }

    public Jedis getJedis() {
        return jedisPool.getResource();
    }

    public String getValue(String key) {
        try (Jedis jedis = getJedis()) {
            return jedis.get(key);
        }
    }

    public  String setValue(String key, String value,int timeout) {
        if(timeout<=0){
            timeout = 30*60;
        }
        try (Jedis jedis = getJedis()) {
            return jedis.setex(key, timeout, value);
        }
    }

    public  String setValue(String key, String value) {
        try (Jedis jedis = getJedis()){
            return jedis.setex(key, 30 * 60, value);
        }
    }


    public  String removeKey(String key) {
        try (Jedis jedis = getJedis()) {
            Long valString = jedis.del(key);
            return valString.toString();
        }
    }

    static {
        config.setMaxTotal(200);
        config.setMaxIdle(200);
        config.setMaxWaitMillis(10000L);
        config.setTestOnBorrow(false);
        try{
            if (SystemConfig.Redis.hasRegisterUrl()) {
                String[] url = SystemConfig.Redis.getHostName().split(":");
                jedisPool = new JedisPool(config, url[0], Integer.parseInt(url[1]));
            }
        }catch (Exception e ){
            log.debug("获取config.json redis配置失败！！");
        }
    }

}
