/*
 * Decompiled with CFR 0.152.
 */
package com.aote.plugins.impexp.exportfile;

import com.af.plugins.timeoutReturn.TimeCache;
import com.aote.ThreadResource;
import com.aote.module.ModuleMapper;
import com.aote.path.PathServer;
import com.aote.plugins.impexp.exportfile.IExportFile;
import com.aote.sql.SqlServer;
import com.aote.util.ExcelUtil;
import com.aote.util.ResourceHelper;
import com.aote.util.SqlHelper;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.hibernate.Session;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class ExportFile
implements IExportFile {
    private JSONObject map = null;
    private static final int MAX_ROWS_PER_SHEET = 50001;
    private static final String defaultCondition = "{orderitem: 'id',condition: '1=1'}";
    static Logger log = Logger.getLogger(ExportFile.class);
    @Autowired
    private DataSource dataSource;
    @Autowired
    private PathServer pathServer;
    @Autowired
    private SqlServer sqlServer;
    @Autowired
    private TimeCache timeCache;
    public static PropertiesConfiguration exportFileConfig;

    public static HttpServletRequest getRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }

    @Override
    public JSONArray export(String condition, String configName) throws Exception {
        this.map = this.getConfig(configName);
        if (this.map == null) {
            return this.noTemplate(condition);
        }
        Set templateNames = this.map.keySet();
        if (templateNames.size() == 0) {
            throw new Exception("\u6b64\u5bfc\u51fa\u9700\u8981\u6a21\u677f\uff0c\u8bf7\u68c0\u67e5impexp/exp/\u8def\u5f84\u4e0b\u7684\u76f8\u5173\u914d\u7f6e\uff01\uff01");
        }
        return this.hasTemplate(templateNames, condition);
    }

    @Override
    public JSONArray export(String condition, String configName, Session session) throws Exception {
        this.map = this.getConfig(configName);
        if (this.map == null) {
            return this.noTemplate(condition, session);
        }
        Set templateNames = this.map.keySet();
        if (templateNames.size() == 0) {
            throw new Exception("\u6b64\u5bfc\u51fa\u9700\u8981\u6a21\u677f\uff0c\u8bf7\u68c0\u67e5impexp/exp/\u8def\u5f84\u4e0b\u7684\u76f8\u5173\u914d\u7f6e\uff01\uff01");
        }
        return this.hasTemplate(templateNames, condition);
    }

    @Override
    public double getExportspeed() {
        return 0.0;
    }

    private JSONObject getConfig(String configName) {
        if (configName == null || "".equals(configName)) {
            return null;
        }
        String dir = (String)ThreadResource.ComponentDir.get();
        if (dir != null) {
            return null;
        }
        Map map = ModuleMapper.getMap();
        for (String key : map.keySet()) {
            try {
                String configStr = ResourceHelper.getString((String)(key + "/impexp/exp/" + configName));
                JSONObject result = new JSONObject(configStr);
                return result;
            }
            catch (Exception e) {
            }
        }
        throw new RuntimeException("\u5bfc\u51fa\u7684\u914d\u7f6e\u6587\u4ef6\u672a\u627e\u5230\uff01" + configName);
    }

    private JSONArray noTemplate(String condition) throws Exception {
        String uuid = new JSONObject(condition).getString("uuid");
        this.timeCache.setCahce(uuid, new JSONObject());
        JSONArray result = new JSONArray();
        JSONObject json = new JSONObject();
        long tick = System.currentTimeMillis();
        String filepath = this.getFilePath(new JSONObject(condition).getString("templateName") + ".xlsx");
        json.put("filename", (Object)filepath);
        result.put((Object)json);
        if (new JSONObject(condition).has("sqlName")) {
            this.export(new JSONObject(condition).getString("sqlName"), condition, null, filepath);
        } else if (new JSONObject(condition).has("pathName")) {
            this.exportpath(new JSONObject(condition).getString("pathName"), condition, null, filepath);
        }
        tick = System.currentTimeMillis() - tick;
        JSONObject cache = new JSONObject();
        cache.put("fileName", (Object)result);
        cache.put("percent", 100);
        this.timeCache.setCahce(uuid, cache);
        log.debug((Object)("\u6700\u7ec8: " + this.timeCache.getCache(uuid)));
        System.out.println("\u8fdb\u884cExcel\u5bfc\u51fa\u8017\u65f6\uff1a" + (double)tick / 1000.0 + "\u79d2");
        System.out.println("\u6587\u4ef6\u540d\uff1a" + result);
        return result;
    }

    private JSONArray noTemplate(String condition, Session session) throws Exception {
        JSONArray result = new JSONArray();
        JSONObject json = new JSONObject();
        long tick = System.currentTimeMillis();
        String filepath = this.getFilePath(new JSONObject(condition).getString("templateName") + ".xlsx");
        json.put("filename", (Object)filepath);
        result.put((Object)json);
        if (new JSONObject(condition).has("sqlName")) {
            this.export(new JSONObject(condition).getString("sqlName"), condition, null, filepath, session);
        } else if (new JSONObject(condition).has("pathName")) {
            this.exportpath(new JSONObject(condition).getString("pathName"), condition, null, filepath);
        }
        tick = System.currentTimeMillis() - tick;
        System.out.println("\u8fdb\u884cExcel\u5bfc\u51fa\u8017\u65f6\uff1a" + (double)tick / 1000.0 + "\u79d2");
        System.out.println("\u6587\u4ef6\u540d\uff1a" + result);
        return result;
    }

    private JSONArray hasTemplate(Set<String> templateNames, String condition) throws Exception {
        JSONArray result = new JSONArray();
        boolean i = false;
        for (String template : templateNames) {
            String sqlName = this.map.getString(template);
            String filepath = this.getFilePath(template);
            JSONObject json = new JSONObject();
            json.put("filename", (Object)filepath);
            result.put((Object)json);
            template = "excel/" + template;
            long tick = System.currentTimeMillis();
            if (!i) {
                this.export(sqlName, condition, template, filepath);
            } else {
                this.export(sqlName, defaultCondition, template, filepath);
            }
            tick = System.currentTimeMillis() - tick;
            System.out.println("\u8fdb\u884cExcel\u5bfc\u51fa\u8017\u65f6\uff1a" + (double)tick / 1000.0 + "\u79d2");
            System.out.println("\u6587\u4ef6\u540d\uff1a" + result);
        }
        return result;
    }

    private String getFilePath(String name) {
        String excelFileName = name == null ? UUID.randomUUID() + ".xlsx" : name;
        String path = ExcelUtil.class.getClassLoader().getResource("config.json").getPath();
        String rootPath = path.split("WEB-INF")[0];
        String filePath = rootPath + "excel/" + excelFileName;
        return filePath;
    }

    private void exportpath(String name, String body, String templateName, String filePath) throws Exception {
        JSONObject joParam = new JSONObject(body);
        String[][] footer = null;
        if (joParam.has("total")) {
            JSONArray totals = joParam.getJSONArray("total");
            footer = this.getFooter(totals);
        }
        JSONObject joVariable = joParam.getJSONObject("data");
        JSONArray result = this.pathServer.query(name, joParam.toString());
        try {
            this.exportWithHedearpath(filePath, joParam, result, footer);
        }
        catch (Exception e) {
            log.error((Object)("\u5bfc\u51fa\u6587\u4ef6: " + name + "\u51fa\u9519\uff0c\u539f\u56e0 \uff1a" + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void export(String name, String body, String templateName, String filePath) throws Exception {
        JSONObject joParam = new JSONObject(body);
        String[][] footer = null;
        if (joParam.has("total")) {
            JSONArray totals = joParam.getJSONArray("total");
            footer = this.getFooter(totals);
        }
        JSONObject joVariable = joParam.getJSONObject("data");
        HashMap<String, Object> params = new HashMap<String, Object>();
        Iterator iterator = joVariable.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Object value = joVariable.get(key);
            params.put(key, value);
        }
        String sql = this.sqlServer.call(name, params);
        sql = SqlHelper.DATA_SOURCE_DIALECT.getSql(sql);
        log.debug((Object)("\u5bfc\u51fa\u6267\u884csql:\n" + sql));
        Connection connection = null;
        Statement preparedStatement = null;
        ResultSet rs = null;
        try {
            connection = this.dataSource.getConnection();
            preparedStatement = connection.prepareStatement(sql, 1004, 1007);
            rs = preparedStatement.executeQuery();
            rs.setFetchSize(50001);
            if (templateName == null) {
                this.exportWithHedear(filePath, joParam, sql, rs, footer);
            } else {
                this.exportWithTemplate(templateName, filePath, rs, footer);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    private void export(String name, String body, String templateName, String filePath, Session session) throws Exception {
        JSONObject joParam = new JSONObject(body);
        String[][] footer = null;
        if (joParam.has("total")) {
            JSONArray totals = joParam.getJSONArray("total");
            footer = this.getFooter(totals);
        }
        JSONObject joVariable = joParam.getJSONObject("data");
        String sql = new SqlServer().call(name, joVariable);
        JSONArray array = SqlHelper.query((Session)session, (String)sql);
        if (templateName == null) {
            this.exportWithHedear(filePath, joParam, sql, array, footer);
        }
    }

    private String[][] getFooter(JSONArray totals) {
        int n = totals.length();
        String[][] footer = new String[n][];
        for (int i = 0; i < n; ++i) {
            JSONObject jo = totals.getJSONObject(i);
            String[] names = JSONObject.getNames((JSONObject)jo);
            Arrays.sort(names, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return Integer.parseInt(o1) - Integer.parseInt(o2);
                }
            });
            footer[i] = new String[names.length];
            for (int j = 0; j < names.length; ++j) {
                footer[i][j] = jo.isNull(names[j]) ? null : jo.get(names[j]) + "";
            }
        }
        return footer;
    }

    private void exportWithTemplate(String templateName, String filePath, ResultSet rs, String[][] footer) throws Exception {
        ExcelUtil eu = new ExcelUtil();
        eu.createBook(templateName, filePath);
        int nCol = rs.getMetaData().getColumnCount();
        int n = 1;
        ArrayList rows = new ArrayList();
        while (rs.next()) {
            if (n % 50001 == 0) {
                eu.createSheet();
                n = 1;
                eu.writeToSheet(rows, null, footer);
                rows = new ArrayList();
            }
            ArrayList<Object> fieldList = new ArrayList<Object>();
            for (int i = 1; i <= nCol; ++i) {
                Object object = rs.getObject(i);
                fieldList.add(object);
            }
            rows.add(fieldList);
            ++n;
        }
        if (n > 1) {
            eu.createSheet();
            eu.writeToSheet(rows, null, footer);
        }
        eu.saveBook();
    }

    private void exportWithHedearpath(String filePath, JSONObject joParam, JSONArray jsonarry, String[][] footer) throws Exception, SQLException {
        int n;
        JSONArray joField = joParam.getJSONArray("field");
        LinkedHashMap<String, String> colsMap = new LinkedHashMap<String, String>();
        this.findOutHeaders(joField, colsMap);
        String[] header = colsMap.values().toArray(new String[colsMap.size()]);
        String[] cols = colsMap.keySet().toArray(new String[colsMap.size()]);
        ExcelUtil eu = new ExcelUtil();
        eu.createBook(null, filePath);
        log.error((Object)("\u6570\u636e\u957f\u5ea6\u662f: " + jsonarry.length()));
        ArrayList rows = new ArrayList();
        for (n = 1; n <= jsonarry.length(); ++n) {
            if (n % 50001 == 0) {
                eu.createSheet();
                n = 1;
                eu.writeToSheet(rows, header, footer);
                rows = new ArrayList();
            }
            ArrayList<Object> fieldList = new ArrayList<Object>();
            for (int i = 0; i < colsMap.size(); ++i) {
                Object object = this.getSObject(jsonarry.getJSONObject(n - 1), cols[i]);
                fieldList.add(object);
            }
            rows.add(fieldList);
        }
        if (n > 1) {
            eu.createSheet();
            eu.writeToSheet(rows, header, footer);
        }
        eu.saveBook();
    }

    private Object getSObject(JSONObject obj, String filestr) {
        Object result = null;
        try {
            String[] strArray = filestr.split("\\.");
            result = obj;
            for (int i = 0; i < strArray.length; ++i) {
                result = this.getSValue((JSONObject)result, strArray[i]);
            }
        }
        catch (Exception e) {
            log.error((Object)("\u89e3\u6790\u5bf9\u8c61\u51fa\u9519: " + obj.toString() + "\u51fa\u9519\uff0c" + filestr + "\u539f\u56e0 \uff1a" + e.getMessage()));
        }
        if (result instanceof JSONObject) {
            result = "";
        }
        return result;
    }

    private Object getSValue(JSONObject obj, String res) {
        Object result = null;
        try {
            if (obj != null) {
                String copy = res;
                if (copy.indexOf("[") > -1 && copy.indexOf("]") > -1) {
                    String intflag = copy.substring(res.indexOf("[") + 1, copy.lastIndexOf("]"));
                    if (intflag.length() > 0) {
                        String prop = res.substring(0, res.indexOf("["));
                        result = obj.has(prop) ? obj.getJSONArray(prop).get(Integer.parseInt(intflag)) : null;
                    }
                } else {
                    result = obj.get(res);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("\u89e3\u6790\u5bf9\u8c61\u51fa\u9519: " + obj.toString() + "\u51fa\u9519\uff0c" + res + "\u539f\u56e0 \uff1a" + e.getMessage()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportWithHedear(String filePath, JSONObject joParam, String sql, ResultSet rs, String[][] footer) {
        ExcelUtil eu = null;
        try {
            Object object;
            int n;
            boolean fromHbm = false;
            boolean isSum = false;
            String[][] newHeader = null;
            if (joParam.has("header")) {
                JSONArray headerArray = joParam.getJSONArray("header");
                n = headerArray.length();
                newHeader = new String[n][];
                this.jsonToTwoArr(newHeader, headerArray, n);
            }
            if (joParam.has("footer")) {
                JSONArray footerArray = joParam.getJSONArray("footer");
                n = footerArray.length();
                String[][] footerth = new String[n][];
                this.jsonToTwoArr(footerth, footerArray, n);
                footer = footerth;
            }
            JSONArray joField = joParam.getJSONArray("field");
            if (joParam.has("sumName") && (object = joParam.get("sumName")) instanceof JSONArray) {
                JSONArray sumName = (JSONArray)object;
                isSum = true;
            }
            List sumNames = null;
            BigDecimal[] sum = null;
            if (isSum) {
                JSONArray sumName = joParam.getJSONArray("sumName");
                sumNames = sumName.toList();
            }
            LinkedHashMap<String, String> colsMap = new LinkedHashMap<String, String>();
            this.findOutHeaders(joField, colsMap);
            String[] header = colsMap.values().toArray(new String[colsMap.size()]);
            String[] cols = colsMap.keySet().toArray(new String[colsMap.size()]);
            eu = new ExcelUtil();
            int cacheInt = exportFileConfig.getInt("cacheInt", 1000);
            boolean compressTempFiles = exportFileConfig.getBoolean("CompressTempFiles", false);
            log.debug((Object)("SXSSFWorkbook\u5bfc\u51fa\u914d\u7f6e: " + cacheInt + ", " + compressTempFiles));
            eu.createBigBook(filePath, cacheInt, compressTempFiles);
            int n2 = 1;
            ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
            if (isSum) {
                sum = new BigDecimal[colsMap.size()];
            }
            rs.last();
            int curcount = 1;
            int totalCount = rs.getRow();
            log.debug((Object)("\u5bfc\u51fa\u603b\u884c\u6570: " + totalCount));
            rs.beforeFirst();
            while (rs.next()) {
                int i;
                if (n2 % 50001 == 0) {
                    eu.createSheet();
                    n2 = 1;
                    eu.writeToSheet(rows, header, footer, newHeader);
                    rows = new ArrayList();
                }
                ArrayList<Object> fieldList = new ArrayList<Object>();
                if (fromHbm) {
                    fieldList.add(rs.getObject("id"));
                }
                int n3 = i = fromHbm ? 1 : 0;
                while (i < colsMap.size()) {
                    Object object2 = rs.getObject(cols[i]);
                    if (sumNames != null && sum != null) {
                        if (sumNames.contains(cols[i])) {
                            if (sum[i] == null) {
                                BigDecimal num2;
                                sum[i] = num2 = new BigDecimal(String.valueOf(object2));
                            } else {
                                BigDecimal num1 = new BigDecimal(String.valueOf(sum[i]));
                                BigDecimal num2 = new BigDecimal(String.valueOf(object2));
                                sum[i] = num1.add(num2);
                            }
                        } else {
                            sum[i] = null;
                        }
                    }
                    fieldList.add(object2);
                    ++i;
                }
                rows.add(fieldList);
                double dPercent = (double)curcount / (double)totalCount;
                int percent = (int)(dPercent * 100.0);
                String uuid = joParam.getString("uuid");
                JSONObject cache = this.timeCache.getCache(uuid);
                cache.put("percent", percent);
                this.timeCache.setCahce(uuid, cache);
                ++n2;
                ++curcount;
            }
            if (sum != null) {
                List<BigDecimal> sums = Arrays.asList(sum);
                rows.add(sums);
            }
            if (n2 > 1) {
                eu.createSheet();
                eu.writeToSheet(rows, header, footer, newHeader);
            }
            eu.saveBook();
        }
        catch (Exception e) {
            try {
                String uuid = joParam.getString("uuid");
                JSONObject cache = this.timeCache.getCache(uuid);
                cache.put("error", (Object)e.getMessage());
                this.timeCache.setCahce(uuid, cache);
            }
            catch (Exception exception) {
                log.debug((Object)"error\u5b58\u5165redis\u5f02\u5e38", (Throwable)exception);
            }
            log.debug((Object)"\u5bfc\u51faexcel\u5f02\u5e38: ", (Throwable)e);
        }
        finally {
            Workbook theBook;
            if (eu != null && (theBook = eu.getTheBook()) instanceof SXSSFWorkbook) {
                log.debug((Object)"\u5220\u9664\u4e34\u65f6\u6587\u4ef6");
                ((SXSSFWorkbook)theBook).dispose();
            }
        }
    }

    private void jsonToTwoArr(String[][] newHeader, JSONArray headerArray, int n) {
        for (int i = 0; i < n; ++i) {
            JSONArray array = headerArray.getJSONArray(i);
            int p = array.length();
            newHeader[i] = new String[p];
            for (int j = 0; j < p; ++j) {
                newHeader[i][j] = String.valueOf(array.get(j));
            }
        }
    }

    private void exportWithHedear(String filePath, JSONObject joParam, String sql, JSONArray array, String[][] footer) throws Exception, SQLException {
        JSONArray sumName;
        Object object;
        boolean fromHbm = false;
        boolean isSum = false;
        JSONArray joField = joParam.getJSONArray("field");
        if (joParam.has("sumName") && (object = joParam.get("sumName")) instanceof JSONArray) {
            sumName = (JSONArray)object;
            isSum = true;
        }
        List sumNames = null;
        BigDecimal[] sum = null;
        if (isSum) {
            sumName = joParam.getJSONArray("sumName");
            sumNames = sumName.toList();
        }
        LinkedHashMap<String, String> colsMap = new LinkedHashMap<String, String>();
        this.findOutHeaders(joField, colsMap);
        String[] header = colsMap.values().toArray(new String[colsMap.size()]);
        String[] cols = colsMap.keySet().toArray(new String[colsMap.size()]);
        ExcelUtil eu = new ExcelUtil();
        eu.createBook(null, filePath);
        int n = 1;
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
        if (isSum) {
            sum = new BigDecimal[colsMap.size()];
        }
        for (Object item : array) {
            int i;
            JSONObject objectItem = (JSONObject)item;
            if (n % 50001 == 0) {
                eu.createSheet();
                n = 1;
                eu.writeToSheet(rows, header, footer);
                rows = new ArrayList();
            }
            ArrayList<Object> fieldList = new ArrayList<Object>();
            if (fromHbm) {
                fieldList.add(objectItem.get("id"));
            }
            int n2 = i = fromHbm ? 1 : 0;
            while (i < colsMap.size()) {
                Object object2 = objectItem.get(cols[i]);
                if (sumNames != null && sum != null) {
                    if (sumNames.contains(cols[i])) {
                        if (sum[i] == null) {
                            BigDecimal num2;
                            sum[i] = num2 = new BigDecimal(String.valueOf(object2));
                        } else {
                            BigDecimal num1 = new BigDecimal(String.valueOf(sum[i]));
                            BigDecimal num2 = new BigDecimal(String.valueOf(object2));
                            sum[i] = num1.add(num2);
                        }
                    } else {
                        sum[i] = null;
                    }
                }
                fieldList.add(object2);
                ++i;
            }
            rows.add(fieldList);
            ++n;
        }
        if (sum != null) {
            List<BigDecimal> sums = Arrays.asList(sum);
            rows.add(sums);
        }
        if (n > 1) {
            eu.createSheet();
            eu.writeToSheet(rows, header, footer);
        }
        eu.saveBook();
    }

    private void findOutHeaders(JSONArray joField, Map<String, String> headers) {
        for (Object temp : joField) {
            String col = ((String)temp).split(":")[0];
            headers.put(col, ((String)temp).split(":")[1]);
        }
    }

    static {
        try {
            exportFileConfig = new PropertiesConfiguration("ExportFileConfig.properties");
            exportFileConfig.setReloadingStrategy((ReloadingStrategy)new FileChangedReloadingStrategy());
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
    }
}

