/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins;

import com.aote.config.SystemConfig;
import com.aote.rs.mapper.WebException;
import java.util.Iterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class RestTools2 {
    public static String post(String path, JSONObject value) {
        JSONObject headers = new JSONObject();
        headers.put("Content-Type", (Object)"application/json");
        return RestTools2.post(path, value.toString(), headers.toString());
    }

    public static String post(String path, String value) {
        return RestTools2.post(path, value, null);
    }

    public static String post(String path, JSONObject value, JSONObject headers) {
        headers.put("Content-Type", (Object)"application/json");
        return RestTools2.post(path, value.toString(), headers.toString());
    }

    public static String post(String path, String value, String headersStr) {
        try {
            CloseableHttpClient httpClient;
            HttpResponse response;
            int code;
            path = SystemConfig.System.getProxyUrl() + path;
            HttpPost postMethod = new HttpPost(path);
            StringEntity se = new StringEntity(value, "UTF-8");
            postMethod.setEntity((HttpEntity)se);
            if (headersStr != null && !"".equals(headersStr)) {
                JSONObject headers = new JSONObject(headersStr);
                Iterator keys = headers.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    String val = headers.getString(key);
                    postMethod.setHeader(key, val);
                }
            }
            if ((code = (response = (httpClient = HttpClientBuilder.create().build()).execute((HttpUriRequest)postMethod)).getStatusLine().getStatusCode()) == 200) {
                return EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF8");
            }
            String data = response.getStatusLine().getReasonPhrase();
            throw new WebException(code, data);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String get(String path) {
        return RestTools2.get(path, null);
    }

    public static String get(String path, JSONObject headers) {
        try {
            CloseableHttpClient httpClient;
            HttpResponse response;
            int code;
            path = SystemConfig.System.getProxyUrl() + path;
            HttpGet getMethod = new HttpGet(path);
            if (headers != null) {
                Iterator keys = headers.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    String val = headers.getString(key);
                    getMethod.setHeader(key, val);
                }
            }
            if ((code = (response = (httpClient = HttpClientBuilder.create().build()).execute((HttpUriRequest)getMethod)).getStatusLine().getStatusCode()) == 200) {
                return EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF8");
            }
            String data = response.getStatusLine().getReasonPhrase();
            throw new WebException(code, data);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static JSONObject getJson(String path) {
        return RestTools2.getJson(path, null);
    }

    public static JSONObject getJson(String path, JSONObject headers) {
        try {
            CloseableHttpClient httpClient;
            HttpResponse response;
            int code;
            HttpGet getMethod = new HttpGet(path);
            getMethod.setHeader("Content-Type", "application/json");
            if (headers != null) {
                Iterator keys = headers.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    String val = headers.getString(key);
                    getMethod.setHeader(key, val);
                }
            }
            if ((code = (response = (httpClient = HttpClientBuilder.create().build()).execute((HttpUriRequest)getMethod)).getStatusLine().getStatusCode()) == 200) {
                JSONObject array;
                String actual = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF8");
                if (actual.startsWith("{")) {
                    array = new JSONObject(actual);
                } else if (actual.startsWith("[")) {
                    array = new JSONArray(actual);
                } else {
                    throw new Exception("\u8c03\u7528rest\u670d\u52a1\u5931\u8d25\u3002");
                }
                JSONObject result = new JSONObject();
                result.put("code", code);
                result.put("data", (Object)array);
                return result;
            }
            JSONObject result = new JSONObject();
            String data = response.getStatusLine().getReasonPhrase();
            result.put("code", code);
            result.put("data", (Object)data);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String delete(String path) {
        return RestTools2.delete(path, null);
    }

    public static String delete(String path, JSONObject headers) {
        path = SystemConfig.System.getProxyUrl() + path;
        HttpDelete deleteMethod = new HttpDelete(path);
        if (headers != null) {
            Iterator keys = headers.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String val = headers.getString(key);
                deleteMethod.setHeader(key, val);
            }
        }
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)deleteMethod);
            int code = response.getStatusLine().getStatusCode();
            if (code == 200) {
                return EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF8");
            }
            String data = response.getStatusLine().getReasonPhrase();
            throw new WebException(code, data);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static JSONObject action(JSONObject param) {
        String action = param.getString("action");
        String url = param.getString("url");
        String data = param.getString("data");
        try {
            HttpPost postMethod = new HttpPost(url);
            StringEntity se = new StringEntity(data, "UTF-8");
            postMethod.setEntity((HttpEntity)se);
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpResponse response = httpClient.execute((HttpUriRequest)postMethod);
            String actual = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF8");
            JSONObject result = new JSONObject();
            int code = response.getStatusLine().getStatusCode();
            result.put("code", code);
            if (code == 200) {
                JSONObject array;
                if (actual.startsWith("{")) {
                    array = new JSONObject(actual);
                } else if (actual.startsWith("[")) {
                    array = new JSONArray(actual);
                } else {
                    throw new Exception("\u8c03\u7528rest\u670d\u52a1\u5931\u8d25\u3002");
                }
                result.put("data", (Object)array);
            } else {
                result.put("data", (Object)actual);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String formatURL(String url, JSONObject params) {
        int capacity = params.length() * 30;
        StringBuilder buffer = new StringBuilder(capacity);
        buffer.append(url).append("?");
        Iterator keys = params.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String val = params.getString(key);
            buffer.append(key).append("=").append(val);
            if (!keys.hasNext()) continue;
            buffer.append("&");
        }
        return buffer.toString();
    }
}

