/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;

public class DateTools {
    public static Date getNow() {
        return DateUtil.date();
    }

    public static String getNow2() {
        return DateUtil.now();
    }

    public static long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static String getNow(String format) {
        return DateUtil.date().toString(format);
    }

    public static String getNowYear() {
        return String.valueOf(DateUtil.thisYear());
    }

    public static String getNowMonth() {
        return String.valueOf(DateTools.getNowMonthAsInt());
    }

    public static int getNowMonthAsInt() {
        return DateUtil.thisMonth() + 1;
    }

    public static String getNowDay() {
        return String.valueOf(DateUtil.thisDayOfMonth());
    }

    public static String getNowDayOfWeek() {
        int value = DateUtil.thisDayOfWeek() - 1;
        if (value == 0) {
            value = 7;
        }
        return String.valueOf(value);
    }

    public static int getMonth(String date) {
        return DateUtil.parse((CharSequence)date).month() + 1;
    }

    public static int getDate(String date) {
        return DateUtil.parse((CharSequence)date).dayOfMonth();
    }

    public static String getYearMonth(String date) {
        return DateUtil.parse((CharSequence)date).toString("yyyyMM");
    }

    public static String format(String datetime, String format) {
        return DateUtil.parse((CharSequence)datetime).toString(format);
    }

    public static String formatConvert(String date) throws ParseException {
        return DateTools.formatDateTime(date, "yyyy-MM-dd");
    }

    public static String formatDateTime(String datetime) {
        return DateTools.format(datetime, "yyyy-MM-dd HH:mm:ss");
    }

    public String formatLongToDate(String date) {
        long dateLong = new Long(date);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date1 = new Date(dateLong);
        return simpleDateFormat.format(date1);
    }

    public static String formatDateTime(String dateStr, String format) {
        return DateUtil.parse((CharSequence)dateStr, (String)format).toString();
    }

    public static String formatDateTime(String dateStr, String format, String newFormat) {
        return DateUtil.parse((CharSequence)dateStr, (String)format).toString(newFormat);
    }

    public static boolean compareDate(String dateStr1, String dateStr2) {
        return DateUtil.compare((Date)DateUtil.parse((CharSequence)dateStr1), (Date)DateUtil.parse((CharSequence)dateStr2)) >= 0;
    }

    public static boolean compareFormatDate(String dateStr1, String dateStr2, String formatStr) {
        return DateUtil.compare((Date)DateUtil.parse((CharSequence)dateStr1, (String)formatStr), (Date)DateUtil.parse((CharSequence)dateStr2, (String)formatStr)) >= 0;
    }

    public static String nextMonth(String date, String day) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date target = simpleDateFormat.parse(date);
        Calendar now = Calendar.getInstance();
        now.setTime(target);
        now.set(now.get(1), now.get(2) + 1, Integer.parseInt(day), 0, 0, 0);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formatter.format(now.getTime());
    }

    public static String getCurrentMonthStart() {
        return DateTools.getStartDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()), "month", "yyyy-MM-dd");
    }

    public static String getLastMonthStart() {
        Calendar c = Calendar.getInstance();
        c.add(2, -1);
        return DateTools.getStartDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(c.getTime()), "month", "yyyy-MM-dd");
    }

    public static String getFrontLastMonthStart() {
        Calendar c = Calendar.getInstance();
        c.add(2, -2);
        return DateTools.getStartDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(c.getTime()), "month", "yyyy-MM-dd");
    }

    public static String getStartDate(String date, String type, String format) {
        if (StrUtil.isBlank((CharSequence)date) || StrUtil.isBlank((CharSequence)type)) {
            throw new RuntimeException("\u83b7\u53d6\u5f00\u59cb\u65f6\u95f4: \u60a8\u6240\u4f20\u7684\u53c2\u6570\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u662f\u5426\u6b63\u786e\uff01\uff01");
        }
        DateTime dateTime = DateUtil.parse((CharSequence)date);
        if ("month".equalsIgnoreCase(type)) {
            return DateUtil.beginOfMonth((Date)dateTime).toString(format);
        }
        if ("year".equalsIgnoreCase(type)) {
            return DateUtil.beginOfYear((Date)dateTime).toString(format);
        }
        return DateUtil.beginOfDay((Date)dateTime).toString(format);
    }

    public static String getStartDate(String date, String type) {
        return DateTools.getStartDate(date, type, "yyyy-MM-dd HH:mm:ss");
    }

    public static String getNextMonthEnd() {
        Calendar c = Calendar.getInstance();
        c.add(2, 1);
        return DateTools.getEndDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(c.getTime()), "month", "yyyy-MM-dd");
    }

    public static String getEndDate(String date, String type, String format) {
        if (StrUtil.isBlank((CharSequence)date) || StrUtil.isBlank((CharSequence)type)) {
            throw new RuntimeException("\u83b7\u53d6\u6700\u540e\u65f6\u95f4: \u60a8\u6240\u4f20\u7684\u53c2\u6570\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u662f\u5426\u6b63\u786e\uff01\uff01");
        }
        DateTime dateTime = DateUtil.parse((CharSequence)date);
        if ("month".equalsIgnoreCase(type)) {
            return DateUtil.endOfMonth((Date)dateTime).toString(format);
        }
        if ("year".equalsIgnoreCase(type)) {
            return DateUtil.endOfYear((Date)dateTime).toString(format);
        }
        return DateUtil.endOfDay((Date)dateTime).toString(format);
    }

    public static String getEndDate(String date, String type) {
        return DateTools.getEndDate(date, type, "yyyy-MM-dd HH:mm:ss");
    }

    public static void main(String[] args) throws Exception {
        String stairStartDate = DateTools.getStairStartDate("2023-01-01 00:00:00", "15", "2023-06-12 00:00:00");
        System.out.println(stairStartDate);
    }

    public static String getStairStartDate(String start, Object cycle, String handdate) throws Exception {
        if ("".equals(start) || start == null) {
            throw new Exception("\u60a8\u6240\u4f20\u7684\u9636\u68af\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!!");
        }
        if (cycle == null) {
            throw new Exception("\u60a8\u6240\u4f20\u7684\u9636\u68af\u5468\u671f\u4e0d\u80fd\u4e3a\u7a7a!!");
        }
        if ("".equals(handdate) || handdate == null) {
            throw new Exception("\u60a8\u6240\u4f20\u7684\u6284\u8868\u5355\u4e0b\u53d1\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!!");
        }
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        long months = ChronoUnit.MONTHS.between(LocalDate.parse(start, dateTimeFormatter), LocalDate.parse(handdate, dateTimeFormatter));
        int ladderMonths = Integer.parseInt(cycle.toString());
        int m = (int)months / ladderMonths;
        return DateTools.getDelayDate(start, "MONTH", String.valueOf(m * ladderMonths));
    }

    public static boolean isLowerDay(int d) {
        Calendar now = Calendar.getInstance();
        int day = now.get(5);
        return day - d < 0;
    }

    private static boolean isLastYear(String date) {
        return DateUtil.parse((CharSequence)date).year() < DateUtil.date().year();
    }

    public static boolean isNull(String param) {
        return "".equals(param) || param == null;
    }

    public static String dateDisp(Date before, Date after) {
        long time = after.getTime() - before.getTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateFormat.format(after) + "-" + dateFormat.format(before) + " \u65f6\u95f4\u5dee:" + time;
    }

    public static String getDiffDate(String type, String param, String format) {
        DateTime dateTime = DateUtil.date();
        return DateTools.getDelayDate(dateTime, type, param, format);
    }

    public static String getDelayDate(String date, String type, String param) {
        DateTime dateTime = DateUtil.parse((CharSequence)date);
        return DateTools.getDelayDate(dateTime, type, param, "yyyy-MM-dd HH:mm:ss");
    }

    public static String getDateBetween(String date1, String date2) {
        return String.valueOf(DateUtil.betweenMs((Date)DateUtil.parse((CharSequence)date1), (Date)DateUtil.parse((CharSequence)date2)));
    }

    public static String getDateDayBetween(String date1, String date2, Boolean isReset) {
        return String.valueOf(DateUtil.betweenDay((Date)DateUtil.parse((CharSequence)date1), (Date)DateUtil.parse((CharSequence)date2), (boolean)isReset));
    }

    private static String getDelayDate(DateTime dateTime, String type, String param, String format) {
        switch (type.toUpperCase()) {
            case "YEAR": {
                dateTime.offset(DateField.YEAR, Integer.parseInt(param));
                break;
            }
            case "MONTH": {
                dateTime.offset(DateField.MONTH, Integer.parseInt(param));
                break;
            }
            case "DATE": 
            case "DAY": {
                dateTime.offset(DateField.DAY_OF_MONTH, Integer.parseInt(param));
                break;
            }
            case "SECOND": {
                dateTime.offset(DateField.SECOND, Integer.parseInt(param));
                break;
            }
            default: {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u65e5\u671f\u7c7b\u578b\uff01\u53ef\u9009\u503c(YEAR,MONTH,DATE,SECOND)");
            }
        }
        return dateTime.toString(format);
    }
}

