/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins.kafka.kafka_producer;

import java.io.IOException;
import java.util.Properties;
import java.util.Random;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;

public class HandlerProducer1
implements Runnable {
    private String message;
    private String topic;
    private int partitionNum;
    private static KafkaProducer<String, String> kafkaProducer;
    private Random random = new Random();
    private static final int RETRY = 3;

    public HandlerProducer1(String topic, int partitionNum, String message) {
        this.topic = topic;
        this.message = message;
        this.partitionNum = partitionNum;
    }

    @Override
    public void run() {
        if (null == kafkaProducer) {
            Properties prop = new Properties();
            try {
                prop.load(HandlerProducer1.class.getResourceAsStream("/kafka_producer.properties"));
                kafkaProducer = new KafkaProducer(prop);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.err.println("\u5f53\u524d\u7ebf\u7a0b:" + Thread.currentThread().getName() + " - " + HandlerProducer1.class + " message : " + this.message);
        ProducerRecord record = new ProducerRecord(this.topic, Integer.valueOf(this.random.nextInt(this.partitionNum)), (Object)"", (Object)this.message);
        kafkaProducer.send(record, (recordMetadata, exception) -> {
            if (null != exception) {
                System.err.println("kafka\u53d1\u9001\u6d88\u606f\u5931\u8d25:" + exception.getMessage() + exception);
                this.retryKakfaMessage(this.topic, this.partitionNum, this.message);
            }
        });
    }

    private void retryKakfaMessage(String retryTopic, int retryPartitionNum, String retryMessage) {
        ProducerRecord record = new ProducerRecord(retryTopic, Integer.valueOf(retryPartitionNum), (Object)"", (Object)retryMessage);
        for (int i = 1; i <= 3; ++i) {
            try {
                kafkaProducer.send(record);
                return;
            }
            catch (Exception e) {
                System.err.println("kafka\u53d1\u9001\u6d88\u606f\u5931\u8d25:" + e.getMessage() + e);
                this.retryKakfaMessage(retryTopic, retryPartitionNum, retryMessage);
                continue;
            }
        }
    }
}

