/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins.kafka.kafka_consumer;

import com.af.plugins.kafka.kafka_consumer.ConsumerGroup;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.json.JSONArray;
import org.json.JSONObject;

public class ConsumerMain {
    public static void main(String[] args) throws Exception {
        Properties prop = new Properties();
        prop.load(ConsumerMain.class.getResourceAsStream("/kafka_consumer.properties"));
        JSONObject params = ConsumerMain.readJsonFile();
        JSONArray topicArray = params.getJSONArray("topics");
        String url = params.getString("serviceUrl");
        int workerNum = params.getInt("workerNum");
        if (topicArray.length() > 0) {
            for (int i = 0; i < topicArray.length(); ++i) {
                JSONObject topic = topicArray.getJSONObject(i);
                String topicName = topic.getString("logicName");
                String groupId = topicName + "-1";
                ConsumerGroup consumerGroup = new ConsumerGroup(workerNum, groupId, prop, topicName, url);
                consumerGroup.execute();
                System.out.println("topic[" + topicName + "]\u521b\u5efa\u5b8c\u6210\uff01");
            }
        }
    }

    private static JSONObject readJsonFile() {
        BufferedReader reader = null;
        StringBuilder laststr = new StringBuilder();
        try {
            String tempString;
            InputStream input = ConsumerMain.class.getResourceAsStream("/topicConfig.json");
            InputStreamReader inputStreamReader = new InputStreamReader(input, StandardCharsets.UTF_8);
            reader = new BufferedReader(inputStreamReader);
            while ((tempString = reader.readLine()) != null) {
                laststr.append(tempString);
            }
            reader.close();
            JSONObject jSONObject = new JSONObject(laststr.toString());
            return jSONObject;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

