/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.HWPFDocumentCore;
import org.apache.poi.hwpf.converter.WordToHtmlConverter;
import org.apache.poi.hwpf.usermodel.Range;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.w3c.dom.Document;

public class XwpfTUtil {
    public ArrayList<String> getReplaceElementsInWord(String filePath, String regex) {
        String[] p = filePath.split("\\.");
        if (p.length > 0) {
            if (p[p.length - 1].equalsIgnoreCase("doc")) {
                ArrayList<String> al = new ArrayList<String>();
                File file = new File(filePath);
                HWPFDocument document = null;
                try {
                    FileInputStream is = new FileInputStream(file);
                    document = new HWPFDocument((InputStream)is);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                Range range = document.getRange();
                String rangeText = range.text();
                CharSequence cs = rangeText.subSequence(0, rangeText.length());
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(cs);
                int startPosition = 0;
                while (matcher.find(startPosition)) {
                    if (!al.contains(matcher.group())) {
                        al.add(matcher.group());
                    }
                    startPosition = matcher.end();
                }
                return al;
            }
            if (p[p.length - 1].equalsIgnoreCase("docx")) {
                ArrayList<String> al = new ArrayList<String>();
                XWPFDocument document = null;
                try {
                    document = new XWPFDocument(POIXMLDocument.openPackage((String)filePath));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                Iterator itPara = document.getParagraphsIterator();
                while (itPara.hasNext()) {
                    XWPFParagraph paragraph = (XWPFParagraph)itPara.next();
                    String paragraphString = paragraph.getText();
                    CharSequence cs = paragraphString.subSequence(0, paragraphString.length());
                    Pattern pattern = Pattern.compile(regex);
                    Matcher matcher = pattern.matcher(cs);
                    int startPosition = 0;
                    while (matcher.find(startPosition)) {
                        if (!al.contains(matcher.group())) {
                            al.add(matcher.group());
                        }
                        startPosition = matcher.end();
                    }
                }
                Iterator itTable = document.getTablesIterator();
                while (itTable.hasNext()) {
                    XWPFTable table = (XWPFTable)itTable.next();
                    int rcount = table.getNumberOfRows();
                    for (int i = 0; i < rcount; ++i) {
                        XWPFTableRow row = table.getRow(i);
                        List cells = row.getTableCells();
                        for (XWPFTableCell cell : cells) {
                            String cellText = "";
                            cellText = cell.getText();
                            CharSequence cs = cellText.subSequence(0, cellText.length());
                            Pattern pattern = Pattern.compile(regex);
                            Matcher matcher = pattern.matcher(cs);
                            int startPosition = 0;
                            while (matcher.find(startPosition)) {
                                if (!al.contains(matcher.group())) {
                                    al.add(matcher.group());
                                }
                                startPosition = matcher.end();
                            }
                        }
                    }
                }
                return al;
            }
            return null;
        }
        return null;
    }

    public static boolean replaceAndGenerateWord(String srcPath, String destPath, Map<String, String> map) {
        String[] sp = srcPath.split("\\.");
        String[] dp = destPath.split("\\.");
        if (sp.length > 0 && dp.length > 0) {
            if (sp[sp.length - 1].equalsIgnoreCase("docx")) {
                try {
                    XWPFDocument document = new XWPFDocument(POIXMLDocument.openPackage((String)srcPath));
                    Iterator itPara = document.getParagraphsIterator();
                    while (itPara.hasNext()) {
                        XWPFParagraph paragraph = (XWPFParagraph)itPara.next();
                        List runs = paragraph.getRuns();
                        for (int i = 0; i < runs.size(); ++i) {
                            String oneparaString = ((XWPFRun)runs.get(i)).getText(((XWPFRun)runs.get(i)).getTextPosition());
                            for (Map.Entry<String, String> entry : map.entrySet()) {
                                oneparaString = oneparaString.replace(entry.getKey(), entry.getValue());
                            }
                            ((XWPFRun)runs.get(i)).setText(oneparaString, 0);
                        }
                    }
                    Iterator itTable = document.getTablesIterator();
                    while (itTable.hasNext()) {
                        XWPFTable table = (XWPFTable)itTable.next();
                        int rcount = table.getNumberOfRows();
                        for (int i = 0; i < rcount; ++i) {
                            XWPFTableRow row = table.getRow(i);
                            List cells = row.getTableCells();
                            for (XWPFTableCell cell : cells) {
                                String cellTextString = cell.getText();
                                for (Map.Entry<String, String> e : map.entrySet()) {
                                    if (!cellTextString.contains(e.getKey())) continue;
                                    cellTextString = cellTextString.replace(e.getKey(), e.getValue());
                                }
                                cell.removeParagraph(0);
                                cell.setText(cellTextString);
                            }
                        }
                    }
                    FileOutputStream outStream = null;
                    outStream = new FileOutputStream(destPath);
                    document.write((OutputStream)outStream);
                    outStream.close();
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            if (sp[sp.length - 1].equalsIgnoreCase("doc") && dp[dp.length - 1].equalsIgnoreCase("doc")) {
                HWPFDocument document = null;
                try {
                    document = new HWPFDocument((InputStream)new FileInputStream(srcPath));
                    Range range = document.getRange();
                    for (Map.Entry<String, String> entry : map.entrySet()) {
                        range.replaceText(entry.getKey(), entry.getValue());
                    }
                    FileOutputStream outStream = null;
                    outStream = new FileOutputStream(destPath);
                    document.write((OutputStream)outStream);
                    outStream.close();
                    return true;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    return false;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    public static String docxToHtml(String sourceFileName, String targetFileName) throws Exception {
        HWPFDocument wordDocument = new HWPFDocument((InputStream)new FileInputStream(sourceFileName));
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        WordToHtmlConverter wordToHtmlConverter = new WordToHtmlConverter(document);
        wordToHtmlConverter.processDocument((HWPFDocumentCore)wordDocument);
        Document htmlDocument = wordToHtmlConverter.getDocument();
        DOMSource domSource = new DOMSource(htmlDocument);
        StreamResult streamResult = new StreamResult(new File(targetFileName));
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer serializer = tf.newTransformer();
        serializer.setOutputProperty("encoding", "utf-8");
        serializer.setOutputProperty("indent", "yes");
        serializer.setOutputProperty("method", "html");
        serializer.transform(domSource, streamResult);
        return targetFileName;
    }

    public static String readfile(String filePath) {
        File file = new File(filePath);
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        StringBuffer buffer = new StringBuffer();
        byte[] bytes = new byte[1024];
        try {
            int n;
            while ((n = ((InputStream)input).read(bytes)) != -1) {
                buffer.append(new String(bytes, 0, n, "utf8"));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer.toString();
    }

    public static String getPath(String pathname) throws IOException {
        String proPath = System.getProperty("user.dir");
        System.out.println(proPath);
        Properties pro = new Properties();
        FileInputStream in = new FileInputStream(proPath + "/file.properties");
        pro.load(in);
        String path = pro.getProperty(pathname);
        System.out.println(path);
        in.close();
        return path;
    }
}

