/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins.office;

import com.af.plugins.office.ExcelWriteHandle;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class EasyExport {
    public String exportFile(JSONObject jsonObject) {
        JSONObject handInfo = jsonObject.getJSONObject("hand");
        JSONArray bodyInfo = jsonObject.getJSONArray("body");
        JSONArray footerInfo = handInfo.getJSONArray("footer");
        bodyInfo = this.getJudgeArray(bodyInfo);
        JSONArray keyNameVS = jsonObject.getJSONObject("hand").getJSONArray("keyNameVS");
        List<List<String>> hand = this.getHand(handInfo);
        List<List<Object>> body = this.getBody(bodyInfo, handInfo, keyNameVS);
        body = this.getFooter(footerInfo, (ArrayList)body);
        String downpath = this.getpath() + jsonObject.get("filename") + ".xlsx";
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)EasyExcel.write((String)downpath).head(hand)).sheet("\u6a21\u677f").registerWriteHandler((WriteHandler)new ExcelWriteHandle(handInfo.getJSONArray("inLine").length(), handInfo.getJSONArray("otherLine").length()))).doWrite(body);
        return downpath;
    }

    private String getpath() {
        String path = EasyExport.class.getClassLoader().getResource("config.json").getPath();
        String rootPath = path.split("WEB-INF")[0] + "/excel/";
        return rootPath;
    }

    private List<List<String>> getHand(JSONObject handInfo) {
        ArrayList<List<String>> handList = new ArrayList<List<String>>();
        JSONArray keyNameVS = handInfo.getJSONArray("keyNameVS");
        boolean isInLine = false;
        if (handInfo.has("inLine")) {
            isInLine = true;
        }
        for (int i = 0; i < keyNameVS.length(); ++i) {
            ArrayList onCloum = new ArrayList();
            if (isInLine) {
                handInfo.getJSONArray("inLine").forEach(v -> onCloum.add(v.toString()));
            }
            handList.add(onCloum);
        }
        return handList;
    }

    private List<List<Object>> getBody(JSONArray bodyInfo, JSONObject handInfo, JSONArray keyNameVS) {
        int i;
        int j;
        ArrayList<List<Object>> list = new ArrayList<List<Object>>();
        JSONArray keyName = new JSONArray();
        boolean isotherLine = false;
        if (handInfo.has("otherLine")) {
            isotherLine = true;
        }
        if (isotherLine) {
            for (int i2 = 0; i2 < handInfo.getJSONArray("otherLine").length(); ++i2) {
                ArrayList<String> data = new ArrayList<String>();
                JSONArray otherLine = handInfo.getJSONArray("otherLine");
                JSONArray otherFild = (JSONArray)otherLine.get(i2);
                for (j = 0; j < otherFild.length(); ++j) {
                    data.add(otherFild.get(j).toString());
                }
                list.add(data);
            }
        }
        ArrayList<String> onCloum = new ArrayList<String>();
        for (i = 0; i < keyNameVS.length(); ++i) {
            onCloum.add(keyNameVS.getString(i).split(":")[1]);
        }
        list.add(onCloum);
        keyNameVS.forEach(v -> {
            String[] kV = v.toString().split(":");
            keyName.put((Object)kV[0]);
        });
        for (i = 0; i < bodyInfo.length(); ++i) {
            ArrayList<Object> data = new ArrayList<Object>();
            JSONObject oneLine = bodyInfo.getJSONObject(i);
            for (j = 0; j < keyName.length(); ++j) {
                data.add(oneLine.get(keyName.get(j).toString()));
            }
            list.add(data);
        }
        return list;
    }

    public List<List<Object>> getFooter(JSONArray footerInfo, ArrayList list) {
        if (footerInfo == null) {
            return list;
        }
        if (footerInfo.length() == 0) {
            return list;
        }
        for (int i = 0; i < footerInfo.length(); ++i) {
            ArrayList<String> data = new ArrayList<String>();
            JSONArray otherFild = (JSONArray)footerInfo.get(i);
            for (int j = 0; j < otherFild.length(); ++j) {
                data.add(otherFild.get(j).toString());
            }
            list.add(data);
        }
        return list;
    }

    public JSONArray getJudgeArray(JSONArray json) {
        if (json == null) {
            return null;
        }
        JSONArray newarray = new JSONArray();
        for (int i = 0; i < json.length(); ++i) {
            JSONObject map = (JSONObject)json.get(i);
            JSONObject newobject = new JSONObject();
            Iterator it = map.keys();
            while (it.hasNext()) {
                String next = (String)it.next();
                Object o = map.get(next);
                if (map.get(next) instanceof BigInteger) {
                    newobject.put(next, (Object)Integer.valueOf(map.get(next).toString()));
                    continue;
                }
                if (map.isNull(next)) {
                    newobject.put(next, (Object)"");
                    continue;
                }
                if (map.get(next) instanceof BigDecimal) {
                    newobject.put(next, (Object)map.get(next).toString());
                    continue;
                }
                if (map.get(next) instanceof Timestamp) {
                    newobject.put(next, (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(map.get(next)));
                    continue;
                }
                newobject.put(next, map.get(next));
            }
            newarray.put((Object)newobject);
        }
        return newarray;
    }
}

