/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins;

import com.alibaba.fastjson.JSON;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonTools {
    public static void validateField(JSONObject obj, Object fields) throws Exception {
        String errors = null;
        for (String string : fields instanceof JSONObject ? new JSONObject(fields.toString()).keySet().toArray() : ((String)fields).split(",")) {
            if (!"".equals(obj.get(string)) && obj.get(string) != null) continue;
            errors = (errors == null ? string : errors + string) + " ";
        }
        if (errors != null) {
            throw new Exception(errors + "\u5b57\u6bb5\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01\uff01");
        }
    }

    public static JSONObject remove(JSONObject colsToBeRemoved, JSONObject jo) {
        Set keySet1 = colsToBeRemoved.keySet();
        for (String s : keySet1) {
            jo.remove(s);
        }
        return jo;
    }

    public static JSONObject add(JSONObject obj, String addLabel, Object addVale) {
        obj.put(addLabel, addVale);
        return obj;
    }

    public static JSONObject addJSON(JSONObject obj, JSONObject addObj) {
        if (addObj == null) {
            throw new NullPointerException("\u8ffd\u52a0\u7684JSONObject\u4e0d\u5b58\u5728\uff01");
        }
        Set keys = addObj.keySet();
        for (String key : keys) {
            obj.put(key, addObj.get(key));
        }
        return obj;
    }

    public static boolean isContains(JSONObject obj, String key) {
        return obj.has(key);
    }

    public static JSONObject removeKey(JSONObject obj, String key) {
        obj.remove(key);
        return obj;
    }

    public static JSONArray getJsonKeys(JSONObject obj) {
        JSONArray array = new JSONArray();
        if (obj != null) {
            for (String str : obj.keySet()) {
                array.put((Object)str);
            }
        }
        return array;
    }

    public static boolean isNull(JSONObject obj, String key) {
        return obj.isNull(key);
    }

    public static boolean isNull(JSONObject obj) {
        return !obj.keys().hasNext();
    }

    public static JSONObject convertToJson(String str) {
        if (str == null || "".equals(str)) {
            return new JSONObject();
        }
        return new JSONObject(str);
    }

    public static com.alibaba.fastjson.JSONObject convertToFastJson(String str) {
        if (str == null || "".equals(str)) {
            return new com.alibaba.fastjson.JSONObject();
        }
        return JSON.parseObject((String)str);
    }

    public static JSONArray parseArray(String str) {
        return new JSONArray(str);
    }

    public static JSONArray getArray() {
        return new JSONArray();
    }

    public static JSONArray getArray(Object val) {
        int len = 0;
        try {
            len = new BigDecimal(val.toString()).intValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new JSONArray((Object)new String[len]);
    }

    public static JSONObject getJson() {
        return new JSONObject();
    }

    public static HashMap<String, Object> toHashMap(JSONObject object) {
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        Iterator it = object.keys();
        while (it.hasNext()) {
            String key = String.valueOf(it.next());
            if (object.isNull(key)) {
                data.put(key, null);
                continue;
            }
            Object value = object.get(key);
            data.put(key, value);
        }
        return data;
    }

    public static JSONArray findDiff(JSONObject jo1, JSONObject jo2) {
        Set keySet1 = jo1.keySet();
        JSONArray jsonArray = new JSONArray();
        for (String s : keySet1) {
            if (!JsonTools.isValueEquals(jo1, jo2, s)) continue;
            JSONObject jo = new JSONObject();
            jo.put("field", (Object)s);
            jo.put("newVal", jo1.get(s) == null ? null : jo1.get(s).toString());
            jo.put("oldVal", jo2.get(s) == null ? null : jo2.get(s).toString());
            jsonArray.put((Object)jo);
        }
        return jsonArray;
    }

    public static boolean isValueEquals(JSONObject jo1, JSONObject jo2, String s) {
        if (jo1.isNull(s) && !jo2.isNull(s) || !jo1.isNull(s) && jo2.isNull(s)) {
            return false;
        }
        if (jo1.isNull(s) && (jo2.isNull(s) || "null".equals(jo2.get(s)))) {
            return false;
        }
        if (jo1.get(s) instanceof Integer) {
            if (jo2.get(s) instanceof BigDecimal) {
                return new BigDecimal((Integer)jo1.get(s)).compareTo((BigDecimal)jo2.get(s)) != 0;
            }
            try {
                return new BigDecimal((Integer)jo1.get(s)).compareTo(new BigDecimal(Integer.valueOf(jo2.get(s).toString()))) != 0;
            }
            catch (Exception e) {
                return false;
            }
        }
        if (jo1.get(s) instanceof String) {
            if (jo2.get(s) instanceof String) {
                return !jo1.get(s).equals(jo2.get(s));
            }
            try {
                return new BigDecimal(Double.valueOf(jo1.get(s).toString())).compareTo((BigDecimal)jo2.get(s)) != 0;
            }
            catch (Exception e) {
                return false;
            }
        }
        if (jo1.get(s) instanceof Double) {
            if (jo2.get(s) instanceof Integer) {
                return new BigDecimal((Double)jo1.get(s)).compareTo(new BigDecimal((Integer)jo2.get(s))) != 0;
            }
            try {
                return new BigDecimal((Double)jo1.get(s)).compareTo(new BigDecimal(Double.parseDouble(jo2.get(s).toString()))) != 0;
            }
            catch (Exception e) {
                return false;
            }
        }
        return !jo2.get(s).equals(jo1.get(s));
    }

    public static JSONArray packJson(JSONObject json, String pricetype) {
        JSONArray result = new JSONArray();
        if ("fixed".equals(pricetype)) {
            JSONObject value = new JSONObject();
            value.put("f_unitprice", (Object)json.getBigDecimal("f_unitprice"));
            result.put((Object)value);
        } else if ("mixed".equals(pricetype)) {
            JSONArray array = (JSONArray)json.get("detailprice");
            JSONObject obj = new JSONObject();
            obj.put("f_hybridprice1", (Object)array.getJSONObject(0).getBigDecimal("f_price"));
            obj.put("f_hybridprice2", (Object)array.getJSONObject(1).getBigDecimal("f_price"));
            obj.put("f_hybridprice1rate", (Object)array.getJSONObject(0).getBigDecimal("f_ratio"));
            result.put((Object)obj);
        } else if ("staired".equals(pricetype)) {
            JSONArray array = (JSONArray)json.get("detailprice");
            for (Object object : array) {
                JSONObject obj = new JSONObject();
                obj.put("price", (Object)((JSONObject)object).getBigDecimal("f_price"));
                obj.put("amount", (Object)((JSONObject)object).getBigDecimal("f_amount"));
                result.put((Object)obj);
            }
            Iterator obj = new JSONObject();
            obj.put("sumamount", json.get("sumamount"));
            result.put((Object)obj);
        }
        return result;
    }

    public static String toString(JSONArray array, String field) {
        StringBuilder result = new StringBuilder();
        for (Object object : array) {
            JSONObject obj = (JSONObject)object;
            String value = obj.optString(field);
            if (!"".equals(result.toString())) {
                result.append(",");
            }
            result.append("'").append(value).append("'");
        }
        return result.toString();
    }

    public static JSONObject readJsonFile(String fileName) {
        BufferedReader reader = null;
        StringBuilder laststr = new StringBuilder();
        try {
            String tempString;
            InputStream input = JsonTools.class.getResourceAsStream("/" + fileName);
            InputStreamReader inputStreamReader = new InputStreamReader(input, StandardCharsets.UTF_8);
            reader = new BufferedReader(inputStreamReader);
            while ((tempString = reader.readLine()) != null) {
                laststr.append(tempString);
            }
            reader.close();
            JSONObject jSONObject = new JSONObject(laststr.toString());
            return jSONObject;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static JSONArray readJsonArrayFile(String fileName) {
        BufferedReader reader = null;
        StringBuilder laststr = new StringBuilder();
        try {
            String tempString;
            InputStream input = JsonTools.class.getResourceAsStream("/" + fileName);
            InputStreamReader inputStreamReader = new InputStreamReader(input, StandardCharsets.UTF_8);
            reader = new BufferedReader(inputStreamReader);
            while ((tempString = reader.readLine()) != null) {
                laststr.append(tempString);
            }
            reader.close();
            JSONArray jSONArray = new JSONArray(laststr.toString());
            return jSONArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static JSONObject replaceJSON(JSONObject oldObj, JSONObject newObj) {
        for (String key : newObj.keySet()) {
            oldObj.put(key, newObj.get(key));
        }
        return oldObj;
    }
}

