/*
 * Decompiled with CFR 0.152.
 */
package com.aote.plugins;

import com.aote.rs.ManagerService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.json.JSONArray;
import org.json.JSONObject;

public class Kafka {
    public static void createTopics(int numPartitions) {
        Properties props = new Properties();
        JSONObject config = Kafka.getConig();
        if (!config.has("kafka")) {
            return;
        }
        JSONObject kafka = config.getJSONObject("kafka");
        if (!kafka.has("server") || !kafka.has("topics")) {
            return;
        }
        try {
            String servers = kafka.getString("server");
            props.put("bootstrap.servers", servers);
            AdminClient adminClient = AdminClient.create((Properties)props);
            Set list = (Set)adminClient.listTopics().names().get();
            HashSet<String> created = new HashSet<String>();
            ArrayList<NewTopic> topics = new ArrayList<NewTopic>();
            JSONArray topicStr = kafka.getJSONArray("topics");
            for (Object o : topicStr) {
                String topic = (String)o;
                created.add(topic);
                if (list.contains(topic)) continue;
                NewTopic newTopic = new NewTopic(topic, numPartitions, 1);
                topics.add(newTopic);
            }
            adminClient.createTopics(topics);
            list.removeAll(created);
            adminClient.deleteTopics((Collection)list);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void produceMsg(String topic, JSONArray news) {
        Properties props = new Properties();
        props.put("acks", "all");
        props.put("retries", (Object)0);
        props.put("batch.size", (Object)16384);
        props.put("linger.ms", (Object)1);
        props.put("buffer.memory", (Object)0x2000000);
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        String servers = Kafka.getConig().getJSONObject("kafka").getString("server");
        props.put("bootstrap.servers", servers);
        KafkaProducer producer = new KafkaProducer(props);
        try {
            for (int i = 0; i < news.length(); ++i) {
                producer.send(new ProducerRecord(topic, (Object)Integer.toString(i), (Object)news.getJSONObject(i).toString()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            producer.close();
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
    }

    public static ConsumerRecords<String, String> consumeMsg(String topic) {
        Properties props = new Properties();
        props.put("group.id", "test");
        props.put("enable.auto.commit", "true");
        props.put("auto.commit.interval.ms", "1000");
        props.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        props.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        String servers = Kafka.getConig().getJSONObject("kafka").getString("server");
        props.put("bootstrap.servers", servers);
        final KafkaConsumer consumer = new KafkaConsumer(props);
        ArrayList<String> topics = new ArrayList<String>();
        topics.add(topic);
        consumer.subscribe(topics, new ConsumerRebalanceListener(){

            public void onPartitionsRevoked(Collection<TopicPartition> collection) {
            }

            public void onPartitionsAssigned(Collection<TopicPartition> collection) {
                consumer.seekToBeginning(collection);
            }
        });
        ConsumerRecords records = consumer.poll(100L);
        try {
            while (true) {
                for (ConsumerRecord record : records) {
                    System.out.printf("offset = %d, key = %s, value = %s%n", record.offset(), record.key(), record.value());
                }
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static JSONObject getConig() {
        ManagerService ms = new ManagerService();
        String config = ms.getConfig();
        return new JSONObject(config);
    }
}

