/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins;

import com.af.plugins.RollingCalendarTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.CountingQuietWriter;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggingEvent;

public class DailyRollingFileAppenderTools
extends FileAppender {
    static final int TOP_OF_TROUBLE = -1;
    static final int TOP_OF_MINUTE = 0;
    static final int TOP_OF_HOUR = 1;
    static final int HALF_DAY = 2;
    static final int TOP_OF_DAY = 3;
    static final int TOP_OF_WEEK = 4;
    static final int TOP_OF_MONTH = 5;
    private String datePattern = "'.'yyyy-MM-dd";
    private String scheduledFilename;
    private long nextCheck = System.currentTimeMillis() - 1L;
    Date now = new Date();
    SimpleDateFormat sdf;
    RollingCalendarTools rc = new RollingCalendarTools();
    int checkPeriod = -1;
    static final TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");
    protected long maxFileSize = 0xA00000L;
    private long nextRollover = 0L;
    private int fileIndex = 0;
    private String fileNamePrefix;
    private String fileNameSuffix;

    public DailyRollingFileAppenderTools() {
    }

    public DailyRollingFileAppenderTools(Layout layout, String filename, String datePattern) throws IOException {
        super(layout, filename, true);
        this.datePattern = datePattern;
        this.activateOptions();
    }

    public void setDatePattern(String pattern) {
        this.datePattern = pattern;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void activateOptions() {
        super.activateOptions();
        if (this.datePattern != null && this.fileName != null) {
            this.now.setTime(System.currentTimeMillis());
            this.sdf = new SimpleDateFormat(this.datePattern);
            int type = this.computeCheckPeriod();
            this.printPeriodicity(type);
            this.rc.setType(type);
            File file = new File(this.fileName);
            if (StringUtils.isEmpty((CharSequence)this.fileNamePrefix) || StringUtils.isEmpty((CharSequence)this.fileNameSuffix)) {
                this.setFileNamePrefix(this.fileName);
                this.setFileNameSuffix(this.fileName);
            }
            this.scheduledFilename = this.initScheduleFilename(this.sdf.format(new Date(file.lastModified())));
        } else {
            LogLog.error((String)("Either File or DatePattern options are not set for appender [" + this.name + "]."));
        }
    }

    public String initScheduleFilename(String lastModifiedDate) {
        this.scheduledFilename = this.fileNamePrefix + lastModifiedDate + "_" + this.fileIndex + this.fileNameSuffix;
        File target = new File(this.scheduledFilename + ".zip");
        if (target.exists()) {
            ++this.fileIndex;
            return this.initScheduleFilename(lastModifiedDate);
        }
        return this.scheduledFilename;
    }

    void printPeriodicity(int type) {
        switch (type) {
            case 0: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled every minute."));
                break;
            }
            case 1: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled on top of every hour."));
                break;
            }
            case 2: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at midday and midnight."));
                break;
            }
            case 3: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at midnight."));
                break;
            }
            case 4: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at start of week."));
                break;
            }
            case 5: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at start of every month."));
                break;
            }
            default: {
                LogLog.warn((String)("Unknown periodicity for appender [" + this.name + "]."));
            }
        }
    }

    int computeCheckPeriod() {
        RollingCalendarTools rollingCalendar = new RollingCalendarTools(gmtTimeZone, Locale.getDefault());
        Date epoch = new Date(0L);
        if (this.datePattern != null) {
            for (int i = 0; i <= 5; ++i) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.datePattern);
                simpleDateFormat.setTimeZone(gmtTimeZone);
                String r0 = simpleDateFormat.format(epoch);
                rollingCalendar.setType(i);
                Date next = new Date(rollingCalendar.getNextCheckMillis(epoch));
                String r1 = simpleDateFormat.format(next);
                if (r0 == null || r1 == null || r0.equals(r1)) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollOver() throws IOException {
        if (this.datePattern == null) {
            this.errorHandler.error("Missing DatePattern option in rollOver().");
        } else {
            String datedFilename = this.fileNamePrefix + this.sdf.format(this.now) + "_" + this.fileIndex + this.fileNameSuffix;
            ++this.fileIndex;
            if (!this.scheduledFilename.equals(datedFilename)) {
                long size = ((CountingQuietWriter)this.qw).getCount();
                this.nextRollover = size + this.maxFileSize;
                this.closeFile();
                File file = new File(this.fileName);
                FileInputStream fis = null;
                ZipOutputStream out = null;
                byte[] buf = new byte[1024];
                try {
                    int len;
                    fis = new FileInputStream(file);
                    out = new ZipOutputStream(new FileOutputStream(this.scheduledFilename + ".zip"));
                    out.putNextEntry(new ZipEntry(file.getPath()));
                    LogLog.debug((String)(this.fileName + " -> " + this.scheduledFilename + ".zip"));
                    while ((len = fis.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    out.closeEntry();
                    fis.close();
                    LogLog.debug((String)(this.fileName + " -> " + this.scheduledFilename + ".zip successful!"));
                }
                catch (Exception e) {
                    LogLog.error((String)("Failed to zip [" + this.fileName + "] is error."));
                }
                finally {
                    if (out != null) {
                        out.closeEntry();
                        out.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                }
                file.delete();
                try {
                    this.setFile(this.fileName, true, this.bufferedIO, this.bufferSize);
                    this.nextRollover = 0L;
                }
                catch (IOException var6) {
                    this.errorHandler.error("setFile(" + this.fileName + ", true) call failed.");
                }
                this.scheduledFilename = datedFilename;
            }
        }
    }

    protected void setQWForFiles(Writer writer) {
        this.qw = new CountingQuietWriter(writer, this.errorHandler);
    }

    public synchronized void setFile(String fileName, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
        super.setFile(fileName, append, this.bufferedIO, this.bufferSize);
        if (append) {
            File f = new File(fileName);
            ((CountingQuietWriter)this.qw).setCount(f.length());
        }
    }

    protected void subAppend(LoggingEvent event) {
        long n = System.currentTimeMillis();
        long size = ((CountingQuietWriter)this.qw).getCount();
        if (n >= this.nextCheck) {
            this.now.setTime(n);
            this.nextCheck = this.rc.getNextCheckMillis(this.now);
            try {
                this.rollOver();
                this.fileIndex = 0;
            }
            catch (IOException var5) {
                if (var5 instanceof InterruptedIOException) {
                    Thread.currentThread().interrupt();
                }
                LogLog.error((String)"rollOver() failed.", (Throwable)var5);
            }
        } else if (size >= this.maxFileSize && size >= this.nextRollover) {
            try {
                this.rollOver();
            }
            catch (IOException var5) {
                if (var5 instanceof InterruptedIOException) {
                    Thread.currentThread().interrupt();
                }
                LogLog.error((String)"rollOver() failed.", (Throwable)var5);
            }
        }
        super.subAppend(event);
    }

    public void setMaxFileSize(String value) {
        this.maxFileSize = OptionConverter.toFileSize((String)value, (long)(this.maxFileSize + 1L));
    }

    public void setFileNamePrefix(String fileNamePrefix) {
        this.fileNamePrefix = this.fileName.substring(0, this.fileName.lastIndexOf("."));
    }

    public void setFileNameSuffix(String fileNameSuffix) {
        this.fileNameSuffix = this.fileName.substring(this.fileName.lastIndexOf("."));
    }
}

