/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;

public class CommonTools {
    public static Object getInstance(String className, JSONArray param) {
        Class<?> classInstance;
        try {
            classInstance = Class.forName(className);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (param != null && param.length() > 0) {
            Object[] objects = new Object[param.length()];
            Class[] paramClasses = new Class[param.length()];
            for (int i = 0; i < param.length(); ++i) {
                objects[i] = param.get(i);
                Class<?> clazz = objects[i].getClass();
                try {
                    Field f = clazz.getDeclaredField("TYPE");
                    paramClasses[i] = (Class)f.get(null);
                    continue;
                }
                catch (NoSuchFieldException e) {
                    paramClasses[i] = clazz;
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                Constructor<?> constructor = classInstance.getDeclaredConstructor(paramClasses);
                constructor.setAccessible(true);
                return constructor.newInstance(objects);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Constructor<?> constructor = classInstance.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getInstance(String className) {
        return CommonTools.getInstance(className, null);
    }

    public static String getUUID() {
        return UUID.randomUUID().toString();
    }

    public static String md5(String param) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            byte[] strTemp = param.getBytes(StandardCharsets.UTF_8);
            MessageDigest mdTemp = MessageDigest.getInstance("MD5");
            mdTemp.update(strTemp);
            byte[] md = mdTemp.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (byte byte0 : md) {
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            return new String(str);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getRandomNumber(Integer min, Integer max) {
        return (int)(Math.random() * (double)(max - min + 1) + (double)min.intValue());
    }

    public static Double stringToDouble(String param) {
        return Double.valueOf(param);
    }

    public static boolean judgeContainsStr(String cardNum) {
        String regex = ".*[a-zA-Z]+.*";
        Matcher m = Pattern.compile(regex).matcher(cardNum);
        return m.matches();
    }

    public static int indexNumber(String value) {
        char[] ch = value.toCharArray();
        int result = 0;
        for (int i = CommonTools.indexCharacter(value) + 1; i < ch.length; ++i) {
            if (ch[i] == '\u0000') continue;
            result = i;
            break;
        }
        return result;
    }

    public static int indexCharacter(String value) {
        char[] ch = value.toCharArray();
        int flag = 0;
        for (int i = ch.length - 1; i >= 0; --i) {
            if (ch[i] >= '0' && ch[i] <= '9') continue;
            flag = i;
            break;
        }
        System.out.println(flag);
        return flag;
    }

    public static List<String> getStringBatch(String value) {
        ArrayList<String> list = new ArrayList<String>();
        if (value.contains(",")) {
            String start = value.split(",")[0];
            String end = value.split(",")[1];
            if (!CommonTools.judgeContainsStr(start) && !CommonTools.judgeContainsStr(end)) {
                String format = "%0" + end.length() + "d";
                for (int i = Integer.parseInt(start); i <= Integer.parseInt(end); ++i) {
                    list.add(String.valueOf(String.format(format, i)));
                }
            } else if (CommonTools.judgeContainsStr(start) && CommonTools.judgeContainsStr(end)) {
                String format = "%0" + String.valueOf(end.length() - (CommonTools.indexCharacter(end) + 1)) + "d";
                String str = end.substring(0, CommonTools.indexCharacter(end) + 1);
                for (int i = CommonTools.getNumber(start); i <= CommonTools.getNumber(end); ++i) {
                    list.add(str + String.format(format, i));
                }
            } else {
                System.out.println("data error");
            }
        } else {
            list.add(value);
        }
        return list;
    }

    private static int getNumber(String value) {
        return Integer.parseInt(value.substring(CommonTools.indexNumber(value) + 1));
    }

    public static String strAdd(String a, int b) throws Exception {
        String result;
        if (a.length() == 1) {
            try {
                return Integer.parseInt(a) + 1 + "";
            }
            catch (Exception e) {
                throw new Exception("\u7f16\u53f7" + a + "\u4e0d\u80fd\u52a0\u4e00");
            }
        }
        String first = a.substring(0, a.length() / 2);
        String last = a.substring(a.length() / 2);
        int temp = new Integer(last) + 1;
        StringBuilder sb = new StringBuilder();
        if (Integer.toString(temp).length() <= last.length()) {
            for (int i = 0; i < last.length() - Integer.toString(temp).length(); ++i) {
                sb.append("0");
            }
            result = first + sb.toString() + Integer.toString(temp);
        } else {
            for (int i = 0; i < last.length(); ++i) {
                sb.append("0");
            }
            first = new Integer(first) + 1 + "";
            result = first + sb.toString();
        }
        return result;
    }

    public static BigDecimal add(Object o1, Object o2) {
        BigDecimal b1 = o1 instanceof Integer ? new BigDecimal((Integer)o1) : (o1 instanceof String ? new BigDecimal((String)o1) : (BigDecimal)o1);
        BigDecimal b2 = o2 instanceof Integer ? new BigDecimal((Integer)o2) : (o2 instanceof String ? new BigDecimal((String)o2) : (BigDecimal)o2);
        return b1.add(b2);
    }

    public static BigDecimal add(Object o1, Object o2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("\u7cbe\u5ea6\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        BigDecimal result = CommonTools.add(o1, o2);
        return result.setScale(scale, 4);
    }

    public static BigDecimal sub(Object o1, Object o2) {
        BigDecimal b1 = o1 instanceof Integer ? new BigDecimal((Integer)o1) : (o1 instanceof String ? new BigDecimal((String)o1) : (BigDecimal)o1);
        BigDecimal b2 = o2 instanceof Integer ? new BigDecimal((Integer)o2) : (o2 instanceof String ? new BigDecimal((String)o2) : (BigDecimal)o2);
        return b1.subtract(b2);
    }

    public static BigDecimal sub(Object o1, Object o2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("\u7cbe\u5ea6\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        BigDecimal result = CommonTools.sub(o1, o2);
        return result.setScale(scale, 4);
    }

    public static double mul(Object o1, Object o2) {
        BigDecimal b1 = o1 instanceof Integer ? new BigDecimal((Integer)o1) : (o1 instanceof String ? new BigDecimal((String)o1) : (BigDecimal)o1);
        BigDecimal b2 = o2 instanceof Integer ? new BigDecimal((Integer)o2) : (o2 instanceof String ? new BigDecimal((String)o2) : (BigDecimal)o2);
        return b1.multiply(b2).doubleValue();
    }

    public static BigDecimal mul(Object o1, Object o2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("\u7cbe\u5ea6\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        double result = CommonTools.mul(o1, o2);
        return new BigDecimal(result).setScale(scale, 4);
    }

    public static double div(Object o1, Object o2) {
        BigDecimal b1 = o1 instanceof Integer ? new BigDecimal((Integer)o1) : (o1 instanceof String ? new BigDecimal((String)o1) : (BigDecimal)o1);
        BigDecimal b2 = o2 instanceof Integer ? new BigDecimal((Integer)o2) : (o2 instanceof String ? new BigDecimal((String)o2) : (BigDecimal)o2);
        return CommonTools.div(b1, b2, 10);
    }

    public static double div(Object o1, Object o2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("\u7cbe\u5ea6\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        BigDecimal b1 = o1 instanceof Integer ? new BigDecimal((Integer)o1) : (o1 instanceof String ? new BigDecimal((String)o1) : (BigDecimal)o1);
        BigDecimal b2 = o2 instanceof Integer ? new BigDecimal((Integer)o2) : (o2 instanceof String ? new BigDecimal((String)o2) : (BigDecimal)o2);
        return b1.divide(b2, scale, 4).doubleValue();
    }

    public static JSONArray split(String str, String separator) {
        if ("|".equals(separator) || "*".equals(separator) || "^".equals(separator)) {
            separator = "\\\\" + separator;
        }
        JSONArray result = new JSONArray();
        if (str != null) {
            for (String value : str.split(separator)) {
                result.put((Object)value);
            }
        }
        return result;
    }

    public static String substring(String str, int start, int end) {
        return str.substring(start, end);
    }

    public static boolean isContains(String str, String target) {
        return str.contains(target);
    }

    public static String union(String str1, String str2) {
        if ("".equals(str1) && "".equals(str2)) {
            return "";
        }
        if (!"".equals(str1) && "".equals(str2)) {
            return str1;
        }
        if ("".equals(str1) && !"".equals(str2)) {
            return str2;
        }
        return str1 + "," + str2;
    }

    public static String union(JSONArray array) {
        StringBuilder result = new StringBuilder();
        for (Object obj : array) {
            String str = (String)obj;
            if (!"".equals(result.toString())) {
                result.append(",");
            }
            result.append("'").append(str).append("'");
        }
        return result.toString();
    }

    public static String parametricStr(String str, Map parametricMap) {
        boolean isReplace;
        boolean bl = isReplace = str.contains("{") && str.contains("}");
        if (isReplace) {
            char[] strArray = str.toCharArray();
            StringBuilder replaceStr = new StringBuilder();
            do {
                int start = str.indexOf("{");
                int end = str.indexOf("}");
                for (int i = start + 1; i < end; ++i) {
                    replaceStr.append(strArray[i]);
                }
                String param = String.valueOf(parametricMap.get(replaceStr.toString()));
                if (param.equals("null")) {
                    return str;
                }
                str = str.replace("{" + replaceStr + "}", param);
                replaceStr.setLength(0);
                strArray = str.toCharArray();
                isReplace = start != -1 && end != -1;
            } while (isReplace);
        }
        return str;
    }
}

