package com.af.plugins.kafka.kafka_producer;

public class HandlerProducer implements Runnable {
    //消息内容
    private String message;
    //话题名称
    private String topic;
    //分区数
    private int partitionNum;

    public HandlerProducer(String topic, int partitionNum, String message) {
        this.topic = topic;
        this.message = message;
        this.partitionNum = partitionNum;
    }

    @Override
    public void run()  {
        KafkaProducerSingleton kafkaProducerSingleton = KafkaProducerSingleton.getInstance();;
        //获取单例
        //初始化生产者参数，重试次数0
        kafkaProducerSingleton.init(topic,0);
        //发送消息
        System.err.println("当前线程:" + Thread.currentThread().getName()
                + ",获取的kafka实例:" + kafkaProducerSingleton + " message : " + message);
        kafkaProducerSingleton.sendKafkaMessage(topic, partitionNum, message);
    }
}