package com.af.plugins.bank;

import com.aote.rs.mapper.WebException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.Socket;

public class jsonToTCP {
    //协议所需的配置
    private JSONObject cfg;
    //请求类型
    private String requestType;
    //返回的报文
    private String message;

    /**
     * 银行接口
     *
     * @param data        请求的json数据
     * @param requestType 请求类型
     * @return 银行返回的结果
     */
    public JSONObject jsontotcp(JSONObject data, String requestType,JSONObject cfg) {
        //获取交易类型（交易码）
        this.requestType = requestType;
        //获取协议对应的配置文件
        this.cfg = cfg;
        //组织报文
        String requestData = getRequestData(data);
        //发送报文
        send(requestData);
        //组织返回数据
        return getResult();
    }

    /**
     * 组织报文
     *
     * @param data 进行组织报文的json数据
     * @return 组织的报文
     */
    private String getRequestData(JSONObject data) {
        //获取组织的报文配置
        StringBuilder result = new StringBuilder();
        String[][] requesCfg = getCfg("requestData", 6);
        for (int i = 0; i < requesCfg.length; i++) {
            String dresult;
            String[] datscfg = requesCfg[i];
            switch (datscfg[2]) {
                case "constant":
                    dresult = datscfg[3];
                    break;
                case "length":
                    dresult = getLength(requesCfg, datscfg[3], 1);
                    break;
                case "variable":
                    dresult = data.getString(datscfg[0]);
                    break;
                case "transition":
                    dresult = getTransition(datscfg[0], data.getString(datscfg[0]));
                    break;
                default:
                    throw new WebException(500, this.requestType + "中requestData组织类型异常" + (i + 1));
            }
            result.append(padding(dresult, datscfg[1], datscfg[4], datscfg[5]));
        }
        return result.toString();
    }

    /**
     * 发送报文,获取请求结果报文
     *
     * @param requestData 报文
     */
//    private void send(String requestData) {
            //模拟
//        System.out.println(requestData);
//        String result = "00000000000118300[交易成功]                                                  ";//查询返回数据
//        System.out.println(result);
//        this.message = result;
//    }
    private void send(String requestData) {
        System.out.println(requestData);
        String result = "";
        try {
            Socket socket = new Socket(this.cfg.getString("path"), this.cfg.getInt("port"));
            OutputStream out = socket.getOutputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            out.write((requestData).getBytes("GBK"));
            out.flush();
            System.out.println(in.readLine());
            result = in.readLine();
            out.close();
            in.close();
            socket.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
        this.message = result;
    }

    /**
     * 组织返回数据
     *
     * @return 用于返回的json数据
     */
    private JSONObject getResult() {
        JSONObject result = new JSONObject();
        String site = this.cfg.getString("resultStatus");
        String succeed = this.cfg.getString("succeed");
        String[][] resultCfg;
        if (succeed.equals(getStringByMessage(site))) {
            resultCfg = getCfg("resultOK", 4);
        } else {
            resultCfg = getCfg("resultNO", 4);
        }
        for (int i = 0; i < resultCfg.length; i++) {
            String dResult;
            String[] datscfg = resultCfg[i];
            switch (datscfg[2]) {
                case "constant":
                    dResult = datscfg[3];
                    break;
                case "variable":
                    dResult = getStringByMessage(datscfg[3]);
                    break;
                case "transition":
                    dResult = getTransition(datscfg[1], getStringByMessage(datscfg[3]));
                    break;
                default:
                    throw new WebException(500, this.requestType + "中requestData组织类型异常" + (i + 1));
            }
            switch (datscfg[0]) {
                case "long":
                    result.put(datscfg[1], Long.parseLong(dResult));
                    break;
                case "int":
                    result.put(datscfg[1], Integer.parseInt(dResult));
                    break;
                case "double":
                    result.put(datscfg[1], Double.parseDouble(dResult));
                    break;
                case "boolean":
                    result.put(datscfg[1], Boolean.parseBoolean(dResult));
                    break;
                default:
                    result.put(datscfg[1], dResult);
            }
        }
        return result;
    }

    /**
     * 获取详细的格式配置数据
     *
     * @param type 数据类型（requestData，resultOK，resultNO）
     * @param leng 单行配置参数个数
     * @return 配置参数
     */
    private String[][] getCfg(String type, int leng) {
        try {
            JSONArray array = this.cfg.getJSONObject(this.requestType).getJSONArray(type);
            String[][] result = new String[array.length()][leng];
            for (int i = 0; i < array.length(); i++) {
                String[] datscfg = array.getString(i).split("=");
                if (datscfg.length == leng) {
                    result[i] = datscfg;
                } else {
                    throw new WebException(500, this.requestType + "中" + type + "配置参数异常,条目 : " + (i + 1));
                }
            }
            return result;
        } catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 数据长度填充
     *
     * @param data   数据
     * @param Size   规定长度
     * @param site   填充位置(left,right)
     * @param filler 填充物
     * @return 长度补充后的数据
     */
    private String padding(String data, String Size, String site, String filler) {
        StringBuilder result = new StringBuilder();
        result.append(data);
        int size = Integer.parseInt(Size);
        int dataLength = data.length();
        if (dataLength < size) {
            for (int i = 0; i < size - dataLength; i++) {
                if ("right".equals(site)) {
                    result.append(filler);
                } else {
                    result.insert(0, filler);
                }
            }
        }
        if (result.length() != size) {
            throw new WebException(500, "数据长度异常，数据 :" + data + ",配置长度:" + Size + ",实际长度:" + result.length());
        }
        return result.toString();
    }

    /**
     * 计算长度（拼接报文时报文中的长度参数）
     *
     * @param datscfg 所计算配置的总数据
     * @param dSite   请求长度计算的范围配置
     * @param site    标准长度记录的位置
     * @return String类型的长度
     */
    private String getLength(String[][] datscfg, String dSite, int site) {
        String[] siteArr = dSite.split("-");
        int result = 0;
        int begin = "begin".equals(siteArr[0]) ? 0 : Integer.parseInt(siteArr[0]) - 1;
        int end = "end".equals(siteArr[1]) ? datscfg.length : Integer.parseInt(siteArr[1]);
        for (int i = begin; i < end; i++) {
            result += Integer.parseInt(datscfg[i][site]);
        }
        return String.valueOf(result);
    }

    /**
     * 转换
     *
     * @param type 转换数据所在值的key
     * @param key  参与转换的数据（为配置中的key值）
     * @return 转换结果值
     */
    private String getTransition(String type, String key) {
        return this.cfg.getJSONObject("transition").getJSONObject(type).getString(key);
    }

    /**
     * 通过配置的位置参数，在报文中截取数据
     *
     * @param site 配置的位置参数
     * @return 截取的数据
     */
    private String getStringByMessage(String site) {
        String[] siteArr = site.split("-");
        int begin = "begin".equals(siteArr[0]) ? 0 : Integer.parseInt(siteArr[0]) - 1;
        int end = "end".equals(siteArr[1]) ? this.message.length() : Integer.parseInt(siteArr[1]);
        return this.message.substring(begin, end);
    }
}
