/*
 * Decompiled with CFR 0.152.
 */
package com.aote.plugins;

import com.github.junrar.Archive;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.FileHeader;
import org.apache.log4j.Logger;

public class Uncompress {
    Logger log = Logger.getLogger(Uncompress.class);
    private String coding = null;

    public void uncompress(String source, String dest) {
        source = source.trim().replace("\\", "/").replace("/", File.separator);
        dest = dest.trim().replace("\\", "/").replace("/", File.separator);
        this.log.debug((Object)("----\u5f00\u59cb\u89e3\u538b\u6587\u4ef6 \uff1a" + source));
        if (source.toLowerCase().endsWith("zip")) {
            this.zip(source, dest);
        } else if (source.toLowerCase().endsWith("rar")) {
            this.rar(source, dest);
        }
        this.log.debug((Object)("----\u89e3\u538b\u5b8c\u6210\uff0c\u5230 \uff1a" + dest));
    }

    public void uncompressCodingZip(String source, String dest, String coding) {
        source = source.trim().replace("\\", "/").replace("/", File.separator);
        dest = dest.trim().replace("\\", "/").replace("/", File.separator);
        this.log.debug((Object)("----\u5f00\u59cb\u89e3\u538b\u6587\u4ef6 \uff1a" + source));
        this.coding = coding;
        if (source.toLowerCase().endsWith("zip")) {
            this.zip(source, dest);
        } else if (source.toLowerCase().endsWith("rar")) {
            this.rar(source, dest);
        }
        this.log.debug((Object)("----\u89e3\u538b\u5b8c\u6210\uff0c\u5230 \uff1a" + dest));
    }

    private void zip(String source, String dest) {
        String password = "password";
        try {
            File zipFile = new File(source);
            ZipFile zFile = new ZipFile(zipFile);
            if (this.coding != null) {
                zFile.setFileNameCharset(this.coding);
            }
            File destDir = new File(dest);
            zFile.extractAll(dest);
            List headerList = zFile.getFileHeaders();
            ArrayList<File> extractedFileList = new ArrayList<File>();
            for (FileHeader fileHeader : headerList) {
                if (fileHeader.isDirectory()) continue;
                extractedFileList.add(new File(destDir, fileHeader.getFileName()));
            }
            File[] extractedFiles = new File[extractedFileList.size()];
            extractedFileList.toArray(extractedFiles);
        }
        catch (ZipException e) {
            this.log.debug((Object)"----\u89e3\u538b\u6587\u4ef6\u5931\u8d25");
        }
    }

    private void rar(String source, String dest) {
        if (!source.toLowerCase().endsWith(".rar")) {
            System.out.println("\u975erar\u6587\u4ef6\uff01");
            return;
        }
        File dstDiretory = new File(dest);
        if (!dstDiretory.exists()) {
            dstDiretory.mkdirs();
        }
        Archive a = null;
        try {
            a = new Archive((InputStream)new FileInputStream(new File(source)));
            if (a.isEncrypted()) {
                System.out.println("\u6e90\u538b\u7f29\u6587\u4ef6\u88ab\u52a0\u5bc6!");
                return;
            }
            a.getMainHeader().print();
            com.github.junrar.rarfile.FileHeader fh = a.nextFileHeader();
            while (fh != null) {
                if (fh.isDirectory()) {
                    File fol = this.existZH(fh.getFileNameW()) ? new File(dest + File.separator + fh.getFileNameW()) : new File(dest + File.separator + fh.getFileNameString());
                    fol.mkdirs();
                } else {
                    File out = this.existZH(fh.getFileNameW()) ? new File(dest + File.separator + fh.getFileNameW().trim()) : new File(dest + File.separator + fh.getFileNameString().trim());
                    try {
                        if (!out.exists()) {
                            if (!out.getParentFile().exists()) {
                                out.getParentFile().mkdirs();
                            }
                            out.createNewFile();
                        }
                        FileOutputStream os = new FileOutputStream(out);
                        a.extractFile(fh, (OutputStream)os);
                        os.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                fh = a.nextFileHeader();
            }
            a.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean existZH(String str) {
        String regEx = "[\\u4e00-\\u9fa5]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.find();
    }
}

