/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins.kafka.kafka_consumer;

import com.af.plugins.xq.AsyncTools;
import java.time.Duration;
import java.util.Collections;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;

public class ConsumerRunnable
implements Runnable {
    private final KafkaConsumer<String, String> consumer;
    private static String url;
    private static AsyncTools asyncTools;

    ConsumerRunnable(String groupId, String topic, Properties prop, String url) {
        ConsumerRunnable.url = url;
        prop.put("group.id", groupId);
        this.consumer = new KafkaConsumer(prop);
        asyncTools = new AsyncTools(){

            @Override
            public void callBack(Boolean result, String httpCode, String response, String body) {
            }
        };
        this.consumer.subscribe(Collections.singletonList(topic));
    }

    @Override
    public void run() {
        while (true) {
            ConsumerRecords records = this.consumer.poll(Duration.ZERO);
            for (ConsumerRecord record : records) {
                asyncTools.postAsync(url + record.topic(), (String)record.value(), (Boolean)false);
                System.out.println(" url: " + url + record.topic() + " val: " + (String)record.value());
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

