package com.af.plugins.kafka.kafka_producer;

import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;

import java.io.IOException;
import java.util.Properties;
import java.util.Random;

public class HandlerProducer1 implements Runnable {
    //消息内容
    private String message;
    //话题名称
    private String topic;
    //分区数
    private int partitionNum;

    private static KafkaProducer<String, String> kafkaProducer;

    private Random random = new Random();

    private static final int RETRY = 3;

    public HandlerProducer1(String topic, int partitionNum, String message) {
        this.topic = topic;
        this.message = message;
        this.partitionNum = partitionNum;
    }

    @Override
    public void run()  {
        if (null == kafkaProducer) {
            //构建配置文件对象
            Properties prop = new Properties();
            try {
                prop.load(HandlerProducer1.class.getResourceAsStream("/kafka_producer.properties"));
                //初始化kafka生产者实例对象
                kafkaProducer = new KafkaProducer<>(prop);
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        //发送消息
        System.err.println("当前线程:" + Thread.currentThread().getName() + " - " +  HandlerProducer1.class + " message : " + message);
        ProducerRecord<String, String> record = new ProducerRecord<String, String>(
                topic, random.nextInt(partitionNum), "", message);
        // send方法是异步的,添加消息到缓存区等待发送,并立即返回，这使生产者通过批量发送消息来提高效率
        // kafka生产者是线程安全的,可以单实例发送消息
        kafkaProducer.send(record, (recordMetadata, exception) -> {
            if (null != exception) {
                System.err.println("kafka发送消息失败:" + exception.getMessage() + exception);
                //重试发送消息
                retryKakfaMessage(topic, partitionNum, message);
            }
        });
//        kafkaProducer.close();
    }

    private void retryKakfaMessage(final String retryTopic,final int retryPartitionNum, final String retryMessage) {
        ProducerRecord<String, String> record = new ProducerRecord<>(
                retryTopic, retryPartitionNum, "", retryMessage);
        for (int i = 1; i <= RETRY; i++) {
            try {
                //重新发送消息
                kafkaProducer.send(record);
                return;
            } catch (Exception e) {
                System.err.println("kafka发送消息失败:" + e.getMessage() + e);
                //递归调用重新发送消息
                retryKakfaMessage(retryTopic,retryPartitionNum,retryMessage);
            }
        }
    }

}