/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins;

import com.af.plugins.HttpAsyncConnectionPoolUtil;
import com.af.plugins.HttpDeleteWithBody;
import java.io.IOException;
import java.util.Iterator;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.json.JSONObject;

public class RestAsyncTools {
    public static void request(String path, String value, String headers, HttpRequestBase base) {
        try {
            JSONObject headerJson = headers == null || "".equals(headers) ? new JSONObject() : new JSONObject(headers);
            if (!headerJson.has("Content-Type")) {
                headerJson.put("Content-Type", (Object)"application/json");
            }
            HttpAsyncConnectionPoolUtil.request(path, value, headerJson.toString(), base);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void post(String path, String value, String headers) {
        RestAsyncTools.request(path, value, headers, (HttpRequestBase)new HttpPost());
    }

    public static void post(String path, JSONObject value, JSONObject headers) {
        if (value == null) {
            RestAsyncTools.post(path, null, headers.toString());
        } else {
            RestAsyncTools.post(path, value.toString(), headers.toString());
        }
    }

    public static void post(String path, JSONObject value) {
        RestAsyncTools.post(path, value.toString(), null);
    }

    public static void post(String path, String value) {
        RestAsyncTools.post(path, value, null);
    }

    public static void post(String path) {
        RestAsyncTools.post(path, "", null);
    }

    public static void get(String path, String headers) {
        RestAsyncTools.request(path, null, headers, (HttpRequestBase)new HttpGet());
    }

    public static void get(String path, JSONObject headers) {
        RestAsyncTools.get(path, headers.toString());
    }

    public static void get(String path) {
        RestAsyncTools.get(path, "");
    }

    public static void put(String path, String value, String headers) {
        RestAsyncTools.request(path, value, headers, (HttpRequestBase)new HttpPut());
    }

    public static void put(String path, JSONObject value, JSONObject headers) {
        if (value == null) {
            RestAsyncTools.put(path, null, headers.toString());
        } else {
            RestAsyncTools.put(path, value.toString(), headers.toString());
        }
    }

    public static void put(String path, String value) {
        RestAsyncTools.put(path, value, "");
    }

    public static void put(String path, JSONObject value) {
        RestAsyncTools.put(path, value.toString(), "");
    }

    public static void put(String path) {
        RestAsyncTools.put(path, "", null);
    }

    public static void delete(String path, String value, String headers) {
        RestAsyncTools.request(path, value, headers, (HttpRequestBase)new HttpDeleteWithBody());
    }

    public static void delete(String path, JSONObject value, JSONObject headers) {
        if (value == null) {
            RestAsyncTools.delete(path, null, headers.toString());
        } else {
            RestAsyncTools.delete(path, value.toString(), headers.toString());
        }
    }

    public static void delete(String path, String value) {
        RestAsyncTools.delete(path, value, "");
    }

    public static void delete(String path, JSONObject value) {
        RestAsyncTools.delete(path, value.toString(), "");
    }

    public static void delete(String path) {
        RestAsyncTools.delete(path, "", null);
    }

    public static String formatURL(String url, JSONObject params) {
        int capacity = params.length() * 30;
        StringBuilder buffer = new StringBuilder(capacity);
        buffer.append(url).append("?");
        Iterator keys = params.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String val = String.valueOf(params.get(key));
            if (!"".equals(val)) {
                buffer.append(key).append("=").append(val);
            } else {
                buffer.append(key);
            }
            if (!keys.hasNext()) continue;
            buffer.append("&");
        }
        return buffer.toString();
    }

    public static String getStandardURL(String protocolType, String url, String port, String paramStr) {
        if (port == null) {
            port = "80";
        }
        url = protocolType + "://" + url + ":" + port;
        if (paramStr != null) {
            url = url + paramStr;
        }
        return url;
    }
}

