/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins;

import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisTools {
    private static Logger log = Logger.getLogger(RedisTools.class);
    private static JedisPool jedisPool;
    private static JedisPoolConfig config;

    public static void getJedisPool(String host, int port) {
        jedisPool = new JedisPool((GenericObjectPoolConfig)config, host, port);
    }

    public static Jedis getJedis() {
        return jedisPool.getResource();
    }

    public static String getValue(String key) {
        try (Jedis jedis = RedisTools.getJedis();){
            String string = jedis.get(key);
            return string;
        }
    }

    public static void addValue(String key, String value) {
        log.info((Object)("redis\u6dfb\u52a0\u6570\u636e\uff0ckey=" + key + ", value=" + value));
        try (Jedis jedis = RedisTools.getJedis();){
            if (jedis.exists(key).booleanValue()) {
                log.warn((Object)("redis\u4e0d\u80fd\u6dfb\u52a0\u6570\u636e\uff0ckey\u5df2\u7ecf\u5b58\u5728\uff0ckey=" + key + ", value=" + value));
            } else {
                jedis.set(key, value);
            }
        }
    }

    public static String setValue(String key, String value) {
        log.info((Object)("redis\u6dfb\u52a0\u6216\u4fee\u6539\u6570\u636e\uff0ckey=" + key + ", value=" + value));
        try (Jedis jedis = RedisTools.getJedis();){
            String string = jedis.set(key, value);
            return string;
        }
    }

    public static String setValue(String key, String value, String redispass) {
        log.info((Object)("redis\u6dfb\u52a0\u6216\u4fee\u6539\u6570\u636e\uff0ckey=" + key + ", value=" + value));
        try (Jedis jedis = RedisTools.getJedis();){
            jedis.auth(redispass);
            String string = jedis.set(key, value);
            return string;
        }
    }

    public static String removeKey(String key) {
        try (Jedis jedis = RedisTools.getJedis();){
            Long valString = jedis.del(key);
            String string = valString.toString();
            return string;
        }
    }

    public static String setBalance(String key, String balance) {
        try (Jedis jedis = RedisTools.getJedis();){
            String result;
            String value = jedis.get(key);
            String[] val = value.split(",");
            val[0] = balance;
            String newValue = RedisTools.splice(val);
            String string = result = jedis.set(key, newValue);
            return string;
        }
    }

    public static String setPrice(String key, JSONObject jObject) {
        try (Jedis jedis = RedisTools.getJedis();){
            JSONArray jo = jObject.getJSONArray("arr");
            String value = jedis.get(key);
            String[] val = value.split(",");
            int length = jo.length();
            for (int i = 0; i < length - 1; ++i) {
                val[i * 2 + 4] = jo.getJSONObject(i).get("f_price").toString();
                val[i * 2 + 5] = jo.getJSONObject(i).get("f_amount").toString();
            }
            val[length + 3] = jo.getJSONObject(length - 1).get("f_price").toString();
            String valueString = RedisTools.splice(val);
            String string = jedis.set(key, valueString);
            return string;
        }
    }

    public static String setOpen(String key, JSONObject jo) {
        try (Jedis jedis = RedisTools.getJedis();){
            String result;
            JSONArray jsonArray = jo.getJSONArray("arr");
            JSONObject jObject = jsonArray.getJSONObject(0);
            JSONArray jArray = jsonArray.getJSONArray(1);
            int length = jArray.length();
            String[] param = new String[length + 4];
            param[0] = jObject.get("balance").toString();
            param[1] = jObject.get("totalquantity").toString();
            param[2] = jObject.get("metertype").toString();
            param[3] = jObject.get("prepaytype").toString();
            for (int i = 0; i < length - 1; ++i) {
                param[i * 2 + 4] = jArray.getJSONObject(i).get("f_price").toString();
                param[i * 2 + 5] = jArray.getJSONObject(i).get("f_amount").toString();
            }
            param[length + 3] = jArray.getJSONObject(length - 1).get("f_price").toString();
            String valueString = RedisTools.splice(param);
            String string = result = jedis.set(key, valueString);
            return string;
        }
    }

    public static String splice(String[] strings) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            if (i == strings.length - 1) {
                stringBuilder.append(strings[i]);
                continue;
            }
            stringBuilder.append(strings[i]).append(",");
        }
        return stringBuilder.toString();
    }

    static {
        config = new JedisPoolConfig();
        config.setMaxTotal(200);
        config.setMaxIdle(200);
        config.setMaxWaitMillis(10000L);
        config.setTestOnBorrow(false);
        jedisPool = new JedisPool((GenericObjectPoolConfig)config, "127.0.0.1", 6379);
    }
}

