package com.af.plugins;

import org.json.JSONArray;
import org.json.JSONObject;

/**
 * @author 张振宇
 * @email 809534382@qq.com
 * @createTime 2022年03月04日
 */
public class ToTree {
    static JSONArray jsonArray = new JSONArray("[\n" +
            "  {\n" +
            "    \"id\": \"parent1\",\n" +
            "    \"f_name\": \"zhineng\",\n" +
            "    \"f_type_id\": null,\n" +
            "    \"value\": 1\n" +
            "  },\n" +
            "  {\n" +
            "    \"id\": \"parent2\",\n" +
            "    \"f_name\": \"baojingqi\",\n" +
            "    \"f_type_id\": null,\n" +
            "    \"value\": 2\n" +
            "  },\n" +
            "  {\n" +
            "    \"id\": \"parent37\",\n" +
            "    \"f_name\": \"yaceji\",\n" +
            "    \"f_type_id\": null,\n" +
            "    \"value\": 37\n" +
            "  },\n" +
            "  {\n" +
            "    \"id\": \"children1\",\n" +
            "    \"f_name\": \"tianxin\",\n" +
            "    \"f_type_id\": \"parent1\",\n" +
            "    \"value\": 1\n" +
            "  },\n" +
            "  {\n" +
            "    \"id\": \"children2\",\n" +
            "    \"f_name\": \"jinka\",\n" +
            "    \"f_type_id\": \"parent1\",\n" +
            "    \"value\": 2\n" +
            "  },\n" +
            "  {\n" +
            "    \"id\": \"children3\",\n" +
            "    \"f_name\": \"huasheng\",\n" +
            "    \"f_type_id\": \"parent37\",\n" +
            "    \"value\": 3\n" +
            "  }\n" +
            "]");


    //    @Test
    // input
    // [{"f_name":"zhineng","id":"parent1","f_type_id":null,"value":1},
    // {"f_name":"baojingqi","id":"parent2","f_type_id":null,"value":2},
    // {"f_name":"yaceji","id":"parent37","f_type_id":null,"value":37},
    // {"f_name":"tianxin","id":"children1","f_type_id":"parent1","value":1},
    // {"f_name":"jinka","id":"children2","f_type_id":"parent1","value":2},
    // {"f_name":"huasheng","id":"children3","f_type_id":"parent37","value":3}]
    //
    // output
    // [
    //     {
    //         "children":
    //         [
    //         {
    //             "f_name": "tianxin",
    //                 "id": "children1",
    //                 "label": "tianxin",
    //                 "f_type_id": "parent1",
    //                 "value": "1"
    //         },
    //         {
    //             "f_name": "jinka",
    //                 "id": "children2",
    //                 "label": "jinka",
    //                 "f_type_id": "parent1",
    //                 "value": "2"
    //         }
    //         ],
    //         "f_name": "zhineng",
    //             "id": "parent1",
    //             "label": "zhineng",
    //             "f_type_id": null,
    //             "value": "1"
    //     },
    //     {
    //         "f_name": "baojingqi",
    //             "id": "parent2",
    //             "label": "baojingqi",
    //             "f_type_id": null,
    //             "value": "2"
    //     },
    //     {
    //         "children":
    //         [
    //         {
    //             "f_name": "huasheng",
    //                 "id": "children3",
    //                 "label": "huasheng",
    //                 "f_type_id": "parent37",
    //                 "value": "3"
    //         }
    //         ],
    //         "f_name": "yaceji",
    //             "id": "parent37",
    //             "label": "yaceji",
    //             "f_type_id": null,
    //             "value": "37"
    //     }
    // ]
    public static void main(String[] args) {
        System.out.println(jsonArray);
        System.out.println(listToTree(jsonArray, "id", "f_type_id", "f_name","value", "children"));
    }

    /**
     * @param arr   数据 [{id,name,parentId},{id,name,parentId}]
     * @param id    自定义组装成功数据的id  默认：id
     * @param pid   自定义组装成功数据的父id  默认：parent_id
     * @param label 自定义组装取值数据  默认：name 含义：如果配置的是 ’label‘ 则取每条数据的 中的’label‘属性作为 返回数据的label属性
     * @param value 自定义组装取值数据  默认：value 含义：如果配置的是 ’value‘ 则取每条数据的 中的’value‘属性作为 返回数据的value属性
     * @param child 自定义子数组的属性名  默认：children
     * @return 一个tree
     * @throws Exception null
     * @tips 每个节点的id需要唯一 如有重复可加标识符如：
     * select 'parent' + cast(id as varchar) id, f_name, null f_type_id
     * from t_iot_device_type
     * union all
     * select 'children' + cast(id as varchar) id, f_brand, 'parent' + cast(isnull(f_type_id, 0) as varchar) f_type_id
     * from t_iot_device_brand;
     */
    public static JSONArray listToTree(JSONArray arr, String id, String pid, String label, String value, String child) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", id);
        jsonObject.put("parent_id", pid);
        jsonObject.put("name", label);
        jsonObject.put("value", value);
        jsonObject.put("children", child);
        return toTree(arr, jsonObject);
    }

    public static JSONArray listToTree(JSONArray arr) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", "id");
        jsonObject.put("parent_id", "parent_id");
        jsonObject.put("name", "label");
        jsonObject.put("value", "value");
        jsonObject.put("children", "children");
        return toTree(arr, jsonObject);
    }


    public static JSONArray toTree(JSONArray data, JSONObject config) {
        JSONObject childrenListMap = new JSONObject();
        JSONObject nodeIds = new JSONObject();
        JSONArray tree = new JSONArray();
        String c_id = config.optString("id");
        String c_parent_id = config.optString("parent_id");
        String c_label = config.optString("name");
        String c_value = config.optString("value");
        String c_children = config.optString("children");
        for (Object jsonObject : data) {
            String _parentId = ((JSONObject) jsonObject).optString(c_parent_id, "顶层");
            String _id = ((JSONObject) jsonObject).optString(c_id);
            if (!childrenListMap.has(_parentId) && childrenListMap.opt(_parentId) == null) {
                childrenListMap.put(_parentId, new JSONArray());
            }
            nodeIds.put(_id, (JSONObject) jsonObject);
            childrenListMap.getJSONArray(_parentId).put((JSONObject) jsonObject);
        }
        for (Object jsonObject : data) {
            String _parentId = ((JSONObject) jsonObject).optString(c_parent_id);
            if (!nodeIds.has(_parentId) && nodeIds.opt(_parentId) == null) {
                tree.put((JSONObject) jsonObject);
            }
        }
        for (Object obj : tree) {
            adaptToChildrenList((JSONObject) obj, childrenListMap, c_id, c_label, c_value, c_children);
        }
        return tree;
    }

    public static void adaptToChildrenList(JSONObject obj, JSONObject childrenListMap, String c_id, String c_label, String c_value, String c_children) {
        obj.put("label", obj.optString(c_label));
        obj.put("value", obj.optString(c_value));
        if (childrenListMap.has(obj.optString(c_id)) && childrenListMap.optString(obj.optString(c_id)) != null) {
            obj.put(c_children, childrenListMap.getJSONArray(obj.optString(c_id)));
        }
        if (obj.has(c_children) && obj.optJSONArray(c_children) != null) {
            for (Object object : obj.getJSONArray(c_children)) {
                adaptToChildrenList((JSONObject) object, childrenListMap, c_id, c_label, c_value, c_children);
            }
        }
    }
}
