package com.af.plugins;

import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.json.JSONObject;

import java.io.IOException;
import java.util.Iterator;


/**
 * REST风格异步请求插件
 */
public class RestAsyncTools {

	/**
	 * 发送通用异步Http请求
	 * @param path  请求路径
	 * @param value 请求参数
	 * @param headers 请求头
	 * @param base  请求类型
	 */
	public static void request(String path, String value, String headers, HttpRequestBase base){
		try {
			JSONObject headerJson;
			if(headers == null || "".equals(headers)){
				headerJson = new JSONObject();
			} else {
				headerJson = new JSONObject(headers);
			}
			if(!headerJson.has("Content-Type")){
				//指定请求参数的数据格式是JSON。
				headerJson.put("Content-Type", "application/json");
			}
			HttpAsyncConnectionPoolUtil.request(path, value, headerJson.toString(), base);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 * 发送post请求
	 *
	 * @param path    请求路径
	 * @param value   请求体
	 * @param headers  请求头
	 * @return String结果
	 */
	public static void post(String path, String value, String headers) {
		request(path, value, headers, new HttpPost());
	}
	public static void post(String path, JSONObject value, JSONObject headers) {
		if(value == null){
			post(path, null, headers.toString());
		} else {
			post(path, value.toString(), headers.toString());
		}
	}
	public static void post(String path, JSONObject value) {
		 post(path, value.toString(), null);
	}
	public static void post(String path, String value) {
		post(path, value, null);
	}
	public static void post(String path){
		post(path, "",null);
	}

	/**
	 * 发送get请求
	 * @param path	请求路径
	 * @param headers 请求头
	 * @return String结果
	 */
	public static void get(String path, String headers) {
		request(path, null, headers, new HttpGet());
	}
	public static void get(String path, JSONObject headers){
		get(path, headers.toString());
	}
	public static void get(String path) {
		get(path, "");
	}

	/**
	 * 发送put请求
	 *
	 * @param path	请求路径
	 * @param value	请求参数
	 * @param headers 请求头
	 * @return String结果
	 */
	public static void put(String path,String value,String headers){
		request(path, value, headers, new HttpPut());
	}
	public static void put(String path,JSONObject value,JSONObject headers){
		if(value == null){
			put(path, null, headers.toString());
		} else {
			put(path, value.toString(), headers.toString());
		}
	}
	public static void put(String path, String value){
		put(path,value,"");
	}
	public static void put(String path, JSONObject value){
		put(path,value.toString(),"");
	}
	public static void put(String path){
		put(path,"",null);
	}

	/**
	 * 发送delete请求
	 *
	 * @param path	请求路径
	 * @param value	请求参数
	 * @param headers 请求头
	 * @return String结果
	 */
	public static void delete(String path,String value,String headers){
		request(path, value, headers, new HttpDeleteWithBody());
	}
	public static void delete(String path,JSONObject value,JSONObject headers){
		if(value == null){
			delete(path, null, headers.toString());
		} else {
			delete(path, value.toString(), headers.toString());
		}
	}
	public static void delete(String path,String value){
		delete(path, value, "");
	}
	public static void delete(String path,JSONObject value){
		delete(path, value.toString(), "");
	}
	public static void delete(String path) {
		delete(path, "", null);
	}

	/**
	 * REST请求路径拼接参数
	 *
	 * @param url   请求路径
	 * @param params 请求参数
	 * @return String结果
	 */
	public static String formatURL(String url, JSONObject params) {
		//设置表单长度30字节*N个请求参数
		int capacity = params.length() * 30;
		//拼接请求路径
		StringBuilder buffer = new StringBuilder(capacity);
		buffer.append(url).append("?");
		//取出JSON里面的请求参数，添加到路径中。
		Iterator<String> keys = params.keys();
		while (keys.hasNext()){
			String key = keys.next();
			String val = String.valueOf(params.get(key));
			if(!"".equals(val)){
				buffer.append(key).append("=").append(val);
			} else {
				buffer.append(key);
			}
			if(keys.hasNext()){
				buffer.append("&");
			}
		}
		return buffer.toString();
	}

	/**
	 * 获取标准格式的请求路径
	 * @param protocolType 协议类型（http,https,ftp...）
	 * @param url 请求ip,域名
	 * @param port 端口，默认80
	 * @param paramStr 需要拼接的路径
	 * @return 标准格式的请求路径
	 */
	public static String getStandardURL(String protocolType,String url,String port,String paramStr){
		if (port == null){
			port = "80";
		}
		url = protocolType+"://"+url+":"+port;
		if(paramStr != null){
			url += paramStr;
		}
		return url;
	}
}
