package com.af.plugins.calculate;

import org.json.JSONArray;
import org.json.JSONObject;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Iterator;

public class PriceDateFormatTools {
    static final NumberFormat NF;
    static {
        NF = NumberFormat.getInstance();
        NF.setGroupingUsed(false);
        NF.setMinimumFractionDigits(2);
        NF.setMaximumFractionDigits(4);
    }

    public static void formatNumber(JSONObject object){
        Iterator<String> iterator = object.keys();
        while (iterator.hasNext()){
            String key = iterator.next();
            Object value = object.get(key);
            if(value instanceof BigDecimal){
                object.put(key, formatNumberBase((BigDecimal) value));
            } else if(value instanceof JSONObject){
                formatNumber((JSONObject) value);
            } else if(value instanceof JSONArray){
                formatNumber((JSONArray) value);
            }
        }
    }

    public static void formatNumber(JSONArray object){
        Iterator<Object> iterator = object.iterator();
        int index = 0;
        while (iterator.hasNext()){
            Object value = iterator.next();
            if(value instanceof BigDecimal){
                object.put(index,formatNumberBase((BigDecimal) value));
            } else if(value instanceof JSONObject){
                formatNumber((JSONObject) value);
            } else if(value instanceof JSONArray){
                formatNumber((JSONArray) value);
            }
            index++;
        }
    }

    public static String formatNumberBase(BigDecimal value){
        return NF.format(value);
    }
}
