package com.af.plugins.xq;

import org.json.JSONArray;
import org.json.JSONObject;
import java.util.*;

/**
 * Json操作工具类
 *
 * (适用于Logic环境)
 *
 * @author Mr.river
 * @date 2019-06-22
 */
public class JsonTools2 {

    /**
     * 获取一个JSONObject空实例
     *
     * @return JSONObject实例
     */
    public static JSONObject getJSONObject(){
        return getJSONObject(null);
    }

    /**
     * 获取JSONObject实例
     *
     * @param str JSON字符串
     * @return JSONObject实例
     */
    public static JSONObject getJSONObject(String str) {
        if(str != null){
            return new JSONObject(str);
        } else {
            return new JSONObject();
        }
    }

    /**
     * 获取一个JSONArray空实例
     *
     * @return JSONArray实例
     */
    public static JSONArray getJSONArray(){
        return getJSONArray(null);
    }

    /**
     * 获取JSONArray实例
     *
     * @param str JSON字符串
     * @return JSONArray实例
     */
    public static JSONArray getJSONArray(String str) {
        if(str != null){
            return new JSONArray(str);
        } else {
            return new JSONArray();
        }
    }

    /**
     * 将JSONObject实例转换为HashMap
     *
     * @param object JSONObject实例
     * @return 转换后的HashMap
     */
    public static Map<String,Object> jsonToMap(JSONObject object) {
        return object.toMap();
    }

    /**
     * 将HashMap实例转换为JSONObject
     *
     * @param object HashMap实例
     * @return 转换后的JSONObject
     */
    public static JSONObject mapToJson(Map object){
        return new JSONObject(object);
    }

    /**
     * 将JSONArray实例转换为List
     *
     * @param array JSONArray实例
     * @return 转换后的List
     */
    public static List<Object> jsonToList(JSONArray array) {
        return array.toList();
    }

    /**
     * 将List实例转换为JSONArray
     *
     * @param object List实例
     * @return 转换后的JSONArray
     */
    public static JSONArray listToJson(List object){
        return new JSONArray(object);
    }

    /**
     * 获取JSONObject实例中Key的集合
     *
     * @param object JSONObject实例
     * @return Key集合
     */
    public static JSONArray getKeys(JSONObject object){
        return new JSONArray(object.keySet());
    }

    /**
     * 将指定的JSON覆盖新JSON中的所有值
     *
     * @param oldObj 被替换的JSONObject实例
     * @param newObj 替换的JSONObject实例
     * @return 处理后的JSON
     */
    public static JSONObject replaceJSON(JSONObject oldObj,JSONObject newObj) {
        for(String key : newObj.keySet()){
            //如果新JSON中有原JSON的键值对，则进行覆盖
            oldObj.put(key,newObj.get(key));
        }
        return oldObj;
    }

    /**
     * 将指定的JSON追加新JSON中的所有值
     *
     * @param oldObj    被追加的JSONObject实例
     * @param addObj 追加的JSONObject实例
     * @return 处理后的JSON
     */
    public static JSONObject addToJSON(JSONObject oldObj, JSONObject addObj) {
        Set<String> keys = addObj.keySet();
        for (String key : keys) {
            oldObj.put(key, addObj.get(key));
        }
        return oldObj;
    }

    /**
     * 将指定的JSONArray追加新JSONArray中的所有值
     *
     * @param oldArray    被追加的JSONArray实例
     * @param addArray 追加的JSONArray实例
     * @return 处理后的JSON
     */
    public static JSONArray addToArray(JSONArray oldArray, JSONArray addArray) {
        for (Object item : addArray) {
            oldArray.put(item);
        }
        return oldArray;
    }
}
