package com.af.plugins;

import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.MD5;
import org.json.JSONArray;
import org.json.JSONObject;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.*;

/**
 * small tools method
 *
 * @author zhaotong
 *
 */
public class CommonTools {
	/**
	 * 获取一个类的实例
	 * @param className 类名（com.af.plugins.CommonTools）
	 * @param param 构造方法参数
	 * @return 实例
	 */
	public static Object getInstance(String className,JSONArray param){
		Class<?> classInstance;
		try {
			//加载类
			classInstance = Class.forName(className);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
		if(param != null && param.length()>0){
			//参数数组
			Object[] objects = new Object[param.length()];
			//参数类型数组
			Class<?>[] paramClasses = new Class[param.length()];
			for(int i=0;i<param.length();i++){
				//获取参数
				objects[i] = param.get(i);
				//获取参数类型
				Class clazz = objects[i].getClass();
				try {
					//如果是基本数据类型
					Field f = clazz.getDeclaredField("TYPE");
					paramClasses[i] = ((Class) f.get(null));
				} catch (NoSuchFieldException e) {
					//如果是类类型
					paramClasses[i] = clazz;
				} catch (IllegalAccessException e) {
					throw new RuntimeException(e);
				}
			}
			//根据构造方法获取实例
			try {
				Constructor constructor = classInstance.getDeclaredConstructor(paramClasses);
				constructor.setAccessible(true);
				return constructor.newInstance(objects);
			} catch (Exception e) {
				throw new RuntimeException(e);
			}
		} else {
			try {
				Constructor constructor = classInstance.getDeclaredConstructor();
				constructor.setAccessible(true);
				return constructor.newInstance();
			} catch (Exception e) {
				throw new RuntimeException(e);
			}
		}
	}

	/**
	 *  获取一个类的实例（无参）
	 *  @param className 类名（com.af.plugins.CommonTools）
	 *  @return 实例
	 */
	public static Object getInstance(String className){
		return getInstance(className, null);
	}

	/**
	 * 获取一个UUID
	 * @param isSimple 是否用“-”分隔
	 * @return UUID字符串
	 */
	public static String getUUID(boolean isSimple){
		return UUID.fastUUID().toString(isSimple);
	}

	/**
	 * 获取一个不用“-”分隔UUID
	 * @return UUID字符串
	 */
	public static String getUUID(){
		return getUUID(false);
	}

	/**
	 * MD5加密
	 * @param param 需要加密的参数
	 * @return MD5加密后的字符串
	 */
	public static String md5(String param) {
		return MD5.create().digestHex(param);
	}

	/**
	 * 获取一个指定范围的伪随机数
	 * @param min 最小值(包含)
	 * @param max 最大值(包含)
	 * @return 伪随机数
	 */
	public static int getRandomNumber(Integer min,Integer max){
		return RandomUtil.randomInt(min,max+1);
	}

	/**
	 * 精确加法运算
	 * @param o1 被加数
	 * @param o2 加数
	 * @return 和
	 */
	public static BigDecimal add(Object o1, Object o2) {
		if(o1 instanceof String || o2 instanceof String){
			return NumberUtil.add(String.valueOf(o1),String.valueOf(o2));
		} else {
			return NumberUtil.add((Number) o1,(Number) o2);
		}
	}

	/**
	 * 精确加法运算(带精度)
	 * WARN：对目标按照精度直接进行截取，即向下舍入操作
	 * @param scale 精度
	 * @param o1 被加数
	 * @param o2 加数
	 * @return 和
	 */
	public static BigDecimal add(Object o1, Object o2, int scale) {
		if (scale < 0) {
			throw new IllegalArgumentException("精度不能小于0");
		}
		BigDecimal result = add(o1, o2);
		return result.setScale(scale, BigDecimal.ROUND_DOWN);
	}

	/**
	 * 精确减法运算
	 * @param o1 被减数
	 * @param o2 减数
	 * @return 差
	 */
	public static BigDecimal sub(Object o1, Object o2) {
		if(o1 instanceof String || o2 instanceof String){
			return NumberUtil.sub(String.valueOf(o1),String.valueOf(o2));
		} else {
			return NumberUtil.sub((Number) o1,(Number) o2);
		}
	}

	/**
	 * 精确减法运算 可以传入精度
	 * WARN：对目标按照精度直接进行截取，即向下舍入操作
	 * @param scale 精度
	 * @param o1 被减数
	 * @param o2 减数
	 * @return 差
	 */
	public static BigDecimal sub(Object o1, Object o2, int scale) {
		if (scale < 0) {
			throw new IllegalArgumentException("精度不能小于0");
		}
		BigDecimal result = sub(o1, o2);
		return result.setScale(scale, BigDecimal.ROUND_DOWN);
	}

	/**
	 * 精确乘法运算
     * @param o1 被乘数
     * @param o2 乘数
     * @return 积
	 */
	public static BigDecimal mul(Object o1, Object o2) {
		if(o1 instanceof String || o2 instanceof String){
			return NumberUtil.mul(String.valueOf(o1),String.valueOf(o2));
		} else {
			return NumberUtil.mul((Number) o1,(Number) o2);
		}
	}

	/**
	 * 精确乘法运算 可以传入精度
	 * WARN：对目标按照精度直接进行截取，即向下舍入操作
	 * @param scale 精度
	 * @param o1 被乘数
	 * @param o2 乘数
	 * @return 积
	 */
	public static BigDecimal mul(Object o1, Object o2, int scale) {
		if (scale < 0) {
			throw new IllegalArgumentException("精度不能小于0");
		}
		BigDecimal result = mul(o1, o2);
		return result.setScale(scale, BigDecimal.ROUND_DOWN);
	}

	/**
	 * 提供(相对)精确的除法运算,当发生除不尽的情况的时候,精确到小数点后10位,后面的四舍五入
     * @param o1 被除数
     * @param o2 除数
     * @return 两个参数的商
	 */
	public static BigDecimal div(Object o1, Object o2) {
		return div(o1,o2,10);
	}

	/**
	 * 提供(相对)精确的除法运算,当发生除不尽的情况时,由scale指定精确度,后面的四舍五入
     * @param o2  对象
     * @param o1  对象
     * @return  double类型的结果集
     * @param scale 精度
	 */
	public static BigDecimal div(Object o1, Object o2, int scale) {
		if (scale < 0) {
			throw new IllegalArgumentException("精度不能小于0");
		}
		if(o1 instanceof String || o2 instanceof String){
			return NumberUtil.div(String.valueOf(o1),String.valueOf(o2),scale);
		} else {
			return NumberUtil.div((Number) o1,(Number) o2,scale);
		}
	}

	/**
	 * 字符串分割
     * @param str 字符串
     * @param separator 以什么方式分割
     * @return JSONArray 集合
	 */
	public static JSONArray split(String str, String separator) {
		return new JSONArray(StrUtil.split(str,separator));
	}

	/**
	 * 指定字符串是否在字符串中出现过
	 *
	 * @param str       字符串
	 * @param searchStr 被查找的字符串
	 * @return 是否包含
	 */
	public static boolean isContains(String str, String searchStr) {
		return StrUtil.contains(str,searchStr);
	}

	/**
	 * 合并一个JSON数组里的所有字符串，形式为：'a','b'
     * @param array 传入一个json数组
     * @return 合并后的字符串
	 */

	public static String union(JSONArray array) {
		StringBuilder result = new StringBuilder();
		array.forEach(item -> {
			result.append("'").append(item).append("',");
		});
		result.deleteCharAt(result.length()-1);
		return result.toString();
	}

	public static String union(JSONArray array,String column) {
		StringBuilder result = new StringBuilder();
		array.forEach(item -> {
			JSONObject itemObject = (JSONObject) item;
			System.out.println(itemObject);
			result.append("'").append(itemObject.get(column)).append("',");
		});
		result.deleteCharAt(result.length()-1);
		return result.toString();
	}

	/**
	 * 格式化参数字符串
	 * @param str 需要格式化的参数字符串，格式：http://{baseUrl}/rs/logic/{logicName}
	 * @param parametricMap 参数映射字典，如：baseUrl: baidu.com , logicName: beta
	 * @return 格式化后的参数字符串，结果：http://baidu.com/rs/logic/beta
	 */
	public static String parametricStr(String str, Map parametricMap){
		boolean isReplace = str.contains("{") && str.contains("}");
		if(isReplace){
			char[] strArray = str.toCharArray();
			StringBuilder replaceStr = new StringBuilder();
			do {
				int start = str.indexOf("{");
				int end = str.indexOf("}");
				//获得需要被替换的key
				for (int i = start + 1; i < end; i++) {
					replaceStr.append(strArray[i]);
				}
				//读取根据key映射字典的值
				String param = String.valueOf(parametricMap.get(replaceStr.toString()));
				//替换字符
				if(!param.equals("null")) {
					str = str.replace("{" + replaceStr + "}", param);
					//清空缓存
					replaceStr.setLength(0);
					strArray = str.toCharArray();
					//重新判断
					isReplace = start != -1 && end != -1;
				} else {
					return str;
				}
			} while (isReplace);
		}
		return str;
	}
}
