/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins;

import com.af.plugins.Config;
import com.af.plugins.HttpDeleteWithBody;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class RestTools {
    private static final int CONNECT_TIMEOUT = Config.getConnectTimeout();
    private static final int SOCKET_TIMEOUT = Config.getConnectTimeout();

    public static String request(String path, String value, String headersStr, HttpEntityEnclosingRequestBase base) {
        base.setURI(URI.create(path));
        if (value != null && !"".equals(value)) {
            StringEntity se = new StringEntity(value, StandardCharsets.UTF_8);
            base.setEntity((HttpEntity)se);
        }
        RestTools.setHeaders(headersStr, base);
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(CONNECT_TIMEOUT).setConnectTimeout(CONNECT_TIMEOUT).setSocketTimeout(SOCKET_TIMEOUT).build();
        base.setConfig(requestConfig);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)base);
            int code = response.getStatusLine().getStatusCode();
            if (code == 200) {
                return EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            }
            String data = response.getStatusLine().getReasonPhrase();
            return "{status: " + code + ", data: '" + data + "'}";
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static String requestPost(String path, String header, String content) {
        return RestTools.post(path, content, header);
    }

    public static HttpEntity requestPostFile(String path, String value, String headersStr, HttpEntityEnclosingRequestBase base) {
        base.setURI(URI.create(path));
        if (value != null && !"".equals(value)) {
            StringEntity se = new StringEntity(value, StandardCharsets.UTF_8);
            base.setEntity((HttpEntity)se);
        }
        RestTools.setHeaders(headersStr, base);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)base);
            int code = response.getStatusLine().getStatusCode();
            if (code == 200) {
                return response.getEntity();
            }
            throw new RuntimeException("\u83b7\u53d6\u6587\u4ef6\u5931\u8d25");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void setHeaders(String headersStr, HttpEntityEnclosingRequestBase base) {
        if (headersStr != null && !"".equals(headersStr)) {
            JSONObject headers = new JSONObject(headersStr);
            Iterator keys = headers.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String val = headers.getString(key);
                base.setHeader(key, val);
            }
        }
    }

    public static String post(String path) {
        return RestTools.post(path, "", null);
    }

    public static String post(String path, JSONObject value) {
        return RestTools.post(path, value, null);
    }

    public static HttpEntity postHttpEntity(String path, JSONObject value) {
        JSONObject headers = new JSONObject();
        headers.put("Content-Type", (Object)"application/json");
        return RestTools.requestPostFile(path, value.toString(), headers.toString(), (HttpEntityEnclosingRequestBase)new HttpPost());
    }

    public static String post(String path, String value) {
        JSONObject headers = new JSONObject();
        return RestTools.request(path, value, headers.toString(), (HttpEntityEnclosingRequestBase)new HttpPost());
    }

    public static String post(String path, String value, String header) {
        return RestTools.request(path, value, header, (HttpEntityEnclosingRequestBase)new HttpPost());
    }

    public static String postheader(String path, String value) {
        JSONObject headers = new JSONObject();
        headers.put("Content-Type", (Object)"application/json");
        return RestTools.request(path, value, headers.toString(), (HttpEntityEnclosingRequestBase)new HttpPost());
    }

    public static String post(String path, JSONObject value, JSONObject headers) {
        if (value != null) {
            if (headers == null) {
                headers = new JSONObject();
            }
            if (!headers.has("Content-Type")) {
                headers.put("Content-Type", (Object)"application/json");
            }
            return RestTools.request(path, value.toString(), headers.toString(), (HttpEntityEnclosingRequestBase)new HttpPost());
        }
        if (headers == null) {
            return RestTools.request(path, "", "", (HttpEntityEnclosingRequestBase)new HttpPost());
        }
        return RestTools.request(path, "", headers.toString(), (HttpEntityEnclosingRequestBase)new HttpPost());
    }

    public static String get(String path) {
        return RestTools.get(path, null);
    }

    public static String get(String path, JSONObject headers) {
        try {
            CloseableHttpClient httpClient;
            HttpResponse response;
            int code;
            HttpGet getMethod = new HttpGet(path);
            if (headers != null) {
                Iterator keys = headers.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    String val = headers.getString(key);
                    getMethod.setHeader(key, val);
                }
            }
            if ((code = (response = (httpClient = HttpClientBuilder.create().build()).execute((HttpUriRequest)getMethod)).getStatusLine().getStatusCode()) == 200) {
                return EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            }
            String data = response.getStatusLine().getReasonPhrase();
            return "{status: " + code + ", data: '" + data + "'}";
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static JSONObject getJson(String path) {
        return RestTools.getJson(path, null);
    }

    public static JSONObject getJson(String path, JSONObject headers) {
        try {
            CloseableHttpClient httpClient;
            HttpResponse response;
            int code;
            HttpGet getMethod = new HttpGet(path);
            getMethod.setHeader("Content-Type", "application/json");
            if (headers != null) {
                Iterator keys = headers.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    String val = headers.getString(key);
                    getMethod.setHeader(key, val);
                }
            }
            if ((code = (response = (httpClient = HttpClientBuilder.create().build()).execute((HttpUriRequest)getMethod)).getStatusLine().getStatusCode()) == 200) {
                JSONObject array;
                String actual = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                if (actual.startsWith("{")) {
                    array = new JSONObject(actual);
                } else if (actual.startsWith("[")) {
                    array = new JSONArray(actual);
                } else {
                    throw new RuntimeException("\u8c03\u7528rest\u670d\u52a1\u5931\u8d25\u3002");
                }
                JSONObject result = new JSONObject();
                result.put("code", code);
                result.put("data", (Object)array);
                return result;
            }
            JSONObject result = new JSONObject();
            String data = response.getStatusLine().getReasonPhrase();
            result.put("code", code);
            result.put("data", (Object)data);
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String put(String path) {
        return RestTools.put(path, null, null);
    }

    public static String put(String path, JSONObject value) {
        return RestTools.put(path, value, null);
    }

    public static String put(String path, String value) {
        if (value != null) {
            JSONObject headers = new JSONObject();
            headers.put("Content-Type", (Object)"application/json");
            return RestTools.request(path, value, headers.toString(), (HttpEntityEnclosingRequestBase)new HttpPut());
        }
        return RestTools.request(path, "", "", (HttpEntityEnclosingRequestBase)new HttpPut());
    }

    public static String put(String path, JSONObject value, JSONObject headers) {
        if (value != null) {
            if (headers == null) {
                headers = new JSONObject();
            }
            headers.put("Content-Type", (Object)"application/json");
            return RestTools.request(path, value.toString(), headers.toString(), (HttpEntityEnclosingRequestBase)new HttpPut());
        }
        if (headers == null) {
            return RestTools.request(path, "", "", (HttpEntityEnclosingRequestBase)new HttpPut());
        }
        return RestTools.request(path, "", headers.toString(), (HttpEntityEnclosingRequestBase)new HttpPut());
    }

    public static String delete(String path) {
        return RestTools.delete(path, null, null);
    }

    public static String delete(String path, JSONObject value) {
        return RestTools.delete(path, value, null);
    }

    public static String delete(String path, String value) {
        return RestTools.request(path, value, "", new HttpDeleteWithBody());
    }

    public static String delete(String path, JSONObject value, JSONObject headers) {
        if (value != null) {
            if (headers == null) {
                headers = new JSONObject();
            }
            headers.put("Content-Type", (Object)"application/json");
            return RestTools.request(path, value.toString(), headers.toString(), new HttpDeleteWithBody());
        }
        if (headers == null) {
            return RestTools.request(path, "", "", new HttpDeleteWithBody());
        }
        return RestTools.request(path, "", headers.toString(), new HttpDeleteWithBody());
    }

    public static String formatURL(String url, JSONObject params) {
        int capacity = params.length() * 30;
        StringBuilder buffer = new StringBuilder(capacity);
        buffer.append(url).append("?");
        Iterator keys = params.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String val = String.valueOf(params.get(key));
            if (!"".equals(val)) {
                buffer.append(key).append("=").append(val);
            } else {
                buffer.append(key);
            }
            if (!keys.hasNext()) continue;
            buffer.append("&");
        }
        return buffer.toString();
    }

    public static String getStandardURL(String protocolType, String url, String port, String paramStr) {
        if (port == null) {
            port = "80";
        }
        url = protocolType + "://" + url + ":" + port;
        if (paramStr != null) {
            url = url + paramStr;
        }
        return url;
    }
}

