/*
 * Decompiled with CFR 0.152.
 */
package com.af.plugins;

import com.alibaba.fastjson.JSON;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonTools {
    public static JSONObject add(JSONObject obj, String addLabel, Object addVale) {
        obj.put(addLabel, addVale);
        return obj;
    }

    public static JSONObject addJSON(JSONObject obj, JSONObject addObj) {
        if (addObj == null) {
            throw new NullPointerException("\u8ffd\u52a0\u7684JSONObject\u4e0d\u5b58\u5728\uff01");
        }
        Set keys = addObj.keySet();
        for (String key : keys) {
            obj.put(key, addObj.get(key));
        }
        return obj;
    }

    public static boolean isContains(JSONObject obj, String key) {
        return obj.has(key);
    }

    public static boolean isNull(JSONObject obj, String key) {
        return obj.isNull(key);
    }

    public static boolean isNull(JSONObject obj) {
        return !obj.isEmpty();
    }

    public static JSONObject convertToJson(String str) {
        if (str == null || "".equals(str)) {
            return new JSONObject();
        }
        return new JSONObject(str);
    }

    public static com.alibaba.fastjson.JSONObject convertToFastJson(String str) {
        if (str == null || "".equals(str)) {
            return new com.alibaba.fastjson.JSONObject();
        }
        return JSON.parseObject((String)str);
    }

    public static JSONArray parseArray(String str) {
        return new JSONArray(str);
    }

    public static JSONArray getArray() {
        return new JSONArray();
    }

    public static JSONArray getArray(Object val) {
        int len;
        try {
            len = new BigDecimal(val.toString()).intValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new JSONArray((Object)new String[len]);
    }

    public static JSONObject getJson() {
        return new JSONObject();
    }

    public static Map<String, Object> toHashMap(JSONObject object) {
        return object.toMap();
    }

    public static JSONArray packJson(JSONObject json, String pricetype) {
        JSONArray result = new JSONArray();
        if ("fixed".equals(pricetype)) {
            JSONObject value = new JSONObject();
            value.put("f_unitprice", (Object)new BigDecimal(String.valueOf(json.get("f_unitprice"))));
            result.put((Object)value);
        } else if ("mixed".equals(pricetype)) {
            JSONArray array = json.getJSONArray("detailprice");
            JSONObject obj = new JSONObject();
            obj.put("f_hybridprice1", (Object)new BigDecimal(String.valueOf(array.getJSONObject(0).get("f_price"))));
            obj.put("f_hybridprice2", (Object)new BigDecimal(String.valueOf(array.getJSONObject(1).get("f_price"))));
            obj.put("f_hybridprice1rate", (Object)new BigDecimal(String.valueOf(array.getJSONObject(0).get("f_ratio"))));
            result.put((Object)obj);
        } else if ("staired".equals(pricetype)) {
            JSONArray array = json.getJSONArray("detailprice");
            for (Object object : array) {
                JSONObject obj = new JSONObject();
                obj.put("price", (Object)new BigDecimal(String.valueOf(((JSONObject)object).get("f_price"))));
                obj.put("amount", (Object)new BigDecimal(String.valueOf(((JSONObject)object).get("f_amount"))));
                result.put((Object)obj);
            }
            Iterator obj = new JSONObject();
            obj.put("sumamount", json.get("sumamount"));
            result.put((Object)obj);
        }
        return result;
    }

    public static JSONObject readJsonFile(String fileName) {
        BufferedReader reader = null;
        StringBuilder laststr = new StringBuilder();
        try {
            String tempString;
            InputStream input = JsonTools.class.getResourceAsStream("/" + fileName);
            InputStreamReader inputStreamReader = new InputStreamReader(input, StandardCharsets.UTF_8);
            reader = new BufferedReader(inputStreamReader);
            while ((tempString = reader.readLine()) != null) {
                laststr.append(tempString);
            }
            reader.close();
            JSONObject jSONObject = new JSONObject(laststr.toString());
            return jSONObject;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static JSONArray readJsonArrayFile(String fileName) {
        BufferedReader reader = null;
        StringBuilder laststr = new StringBuilder();
        try {
            String tempString;
            InputStream input = JsonTools.class.getResourceAsStream("/" + fileName);
            InputStreamReader inputStreamReader = new InputStreamReader(input, StandardCharsets.UTF_8);
            reader = new BufferedReader(inputStreamReader);
            while ((tempString = reader.readLine()) != null) {
                laststr.append(tempString);
            }
            reader.close();
            JSONArray jSONArray = new JSONArray(laststr.toString());
            return jSONArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static JSONObject replaceJSON(JSONObject oldObj, JSONObject newObj) {
        for (String key : newObj.keySet()) {
            oldObj.put(key, newObj.get(key));
        }
        return oldObj;
    }
}

